/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.DefaultFileResource;
import org.jdrupes.builder.core.DefaultFileTree;
import org.jdrupes.builder.core.DefaultResources;
import org.jdrupes.builder.core.ResourceObject;

public class CoreResourceFactory
implements ResourceFactory {
    public static <T> boolean addsMethod(Class<T> base, Class<? extends T> derived) {
        Set baseItfs = ResourceType.getAllInterfaces(base).collect(Collectors.toSet());
        return ResourceType.getAllInterfaces(derived).filter(Predicate.not(baseItfs::contains)).filter(itf -> itf.getDeclaredMethods().length > 0).findAny().isPresent();
    }

    @Override
    public <T extends Resource> Optional<T> newResource(ResourceType<T> type, Project project, Object ... args) {
        if (ResourceType.FileResourceType.isAssignableFrom(type) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(FileResource.class, type.rawType())) {
            return Optional.of(DefaultFileResource.createFileResource(type, (Path)args[0]));
        }
        if (Resources.class.isAssignableFrom(type.rawType()) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(Resources.class, type.rawType())) {
            return Optional.of(DefaultResources.createResources(type));
        }
        if (FileTree.class.isAssignableFrom(type.rawType()) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(FileTree.class, type.rawType())) {
            return Optional.of(DefaultFileTree.createFileTree(type, project, (Path)args[0], (String)args[1]));
        }
        if (Resource.class.isAssignableFrom(type.rawType()) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(Resource.class, type.rawType())) {
            return Optional.of(ResourceObject.createResource(type));
        }
        return Optional.empty();
    }
}

