/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.jdrupes.builder.api.BuildContext;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.core.FutureStream;
import org.jdrupes.builder.core.FutureStreamCache;
import org.jdrupes.builder.core.LauncherSupport;

public class DefaultBuildContext
implements BuildContext {
    public static final String JDBLD_DIRECTORY = "jdbldDirectory";
    private final FutureStreamCache cache;
    private ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();

    DefaultBuildContext() {
        this.cache = new FutureStreamCache();
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public <T extends Resource> Stream<T> get(ResourceProvider provider, ResourceRequest<T> request) {
        return this.cache.computeIfAbsent(new FutureStreamCache.Key<T>(provider, request), k -> new FutureStream(this.executor, k.provider(), k.requested())).stream();
    }

    @Override
    public Path jdbldDirectory() {
        return Path.of(LauncherSupport.jdbldProperties().getProperty(JDBLD_DIRECTORY), new String[0]);
    }

    @Override
    public CommandLine commandLine() {
        return LauncherSupport.commandLine();
    }

    @Override
    public String property(String name) {
        return LauncherSupport.jdbldProperties().getProperty(name);
    }
}

