/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.Proxyable;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.ForwardingHandler;
import org.jdrupes.builder.core.ResourceObject;

public class DefaultFileResource
extends ResourceObject
implements FileResource {
    private final Path path;

    protected DefaultFileResource(ResourceType<? extends FileResource> type, Path path) {
        super(type);
        if (!path.isAbsolute()) {
            throw new BuildException("Path must be absolute, is " + String.valueOf(path));
        }
        this.path = path;
    }

    public static <T extends FileResource> T createFileResource(ResourceType<T> type, Path path) {
        return (T)((FileResource)Proxy.newProxyInstance(type.rawType().getClassLoader(), new Class[]{type.rawType(), Proxyable.class}, (InvocationHandler)new ForwardingHandler(new DefaultFileResource(type, path))));
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Instant asOf() {
        if (!this.path.toFile().exists()) {
            return Instant.MIN;
        }
        return Instant.ofEpochMilli(this.path.toFile().lastModified());
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream outputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.path);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        FileResource other;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof FileResource && Objects.equals(this.path, (other = (FileResource)obj).path());
    }

    @Override
    public String toString() {
        Path relPath = Path.of("", new String[0]).toAbsolutePath().relativize(this.path);
        return String.valueOf(this.type()) + ": " + (relPath.equals(Path.of("", new String[0])) ? "." : relPath.toString()) + " (" + this.asOfLocalized() + ")";
    }
}

