/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Proxyable;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.DefaultResources;
import org.jdrupes.builder.core.ForwardingHandler;

public class DefaultFileTree<T extends FileResource>
extends DefaultResources<T>
implements FileTree<T> {
    private Instant latestChange = Instant.MIN;
    private final Project project;
    private final Path root;
    private final String pattern;
    private final List<String> excludes = new ArrayList<String>();
    private boolean withDirs;
    private boolean filled;

    protected DefaultFileTree(ResourceType<?> type, Project project, Path root, String pattern) {
        super(type);
        this.project = project;
        this.root = root;
        this.pattern = pattern;
    }

    public static <T extends FileTree<?>> T createFileTree(ResourceType<T> type, Project project, Path root, String pattern) {
        return (T)((FileTree)Proxy.newProxyInstance(type.rawType().getClassLoader(), new Class[]{type.rawType(), Proxyable.class}, (InvocationHandler)new ForwardingHandler(new DefaultFileTree<T>(type, project, root, pattern))));
    }

    @Override
    public FileTree<T> withDirectories() {
        this.withDirs = true;
        return this;
    }

    @Override
    public FileTree<T> exclude(String pattern) {
        this.excludes.add(pattern);
        return this;
    }

    @Override
    public Path root(boolean relativize) {
        if (this.project == null) {
            return this.root.toAbsolutePath();
        }
        Path result = this.project.directory().resolve(this.root).normalize();
        if (relativize) {
            return this.project.directory().relativize(result);
        }
        return result;
    }

    @Override
    public Path root() {
        return this.root(false);
    }

    private void fill() {
        if (this.filled) {
            return;
        }
        try {
            this.find(this.root(), this.pattern);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e, () -> "Problem scanning files: " + e.getMessage());
            throw new BuildException(e);
        }
        this.filled = true;
    }

    @Override
    public Instant asOf() {
        this.fill();
        return this.latestChange;
    }

    private void find(final Path root, String pattern) throws IOException {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        final List<PathMatcher> excludeMatchers = this.excludes.parallelStream().map(e -> FileSystems.getDefault().getPathMatcher("glob:" + e)).toList();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                return this.testAndAdd(path);
            }

            private FileVisitResult testAndAdd(Path path) {
                if (excludeMatchers.parallelStream().filter(em -> em.matches(root.relativize(path))).findAny().isPresent()) {
                    if (path.toFile().isDirectory()) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
                if (pathMatcher.matches(path)) {
                    FileResource resource = (FileResource)ResourceFactory.create(DefaultFileTree.this.type().containedType(), path);
                    DefaultFileTree.this.add(resource);
                    if (resource.asOf().isAfter(DefaultFileTree.this.latestChange)) {
                        DefaultFileTree.this.latestChange = resource.asOf();
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (DefaultFileTree.this.withDirs) {
                    return this.testAndAdd(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Instant dirMod = Instant.ofEpochMilli(dir.toFile().lastModified());
                if (dirMod.isAfter(DefaultFileTree.this.latestChange)) {
                    DefaultFileTree.this.latestChange = dirMod;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            private Iterator<T> theIterator;

            private Iterator<T> iterator() {
                if (this.theIterator == null) {
                    DefaultFileTree.this.fill();
                    this.theIterator = DefaultFileTree.super.stream().iterator();
                }
                return this.theIterator;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                this.iterator().forEachRemaining(action);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!this.iterator().hasNext()) {
                    return false;
                }
                action.accept(this.iterator().next());
                return true;
            }
        }, false);
    }

    @Override
    public FileTree<T> clear() {
        super.clear();
        this.filled = false;
        return this;
    }

    @Override
    public FileTree<T> delete() {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.pattern);
        try {
            final Path root = this.root();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (pathMatcher.matches(path)) {
                        Files.delete(path);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (!dir.equals(root) && Files.list(dir).findFirst().isEmpty()) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc instanceof AccessDeniedException) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e, () -> "Problem scanning files: " + e.getMessage());
            throw new BuildException(e);
        }
        this.filled = false;
        return this;
    }

    @Override
    public Stream<Path> entries() {
        return this.stream().map(fr -> this.root().relativize(fr.path()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.excludes, this.pattern, this.root, this.withDirs);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof DefaultFileTree) {
            DefaultFileTree other = (DefaultFileTree)obj;
            if (Objects.equals(this.excludes, other.excludes) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.root, other.root) && this.withDirs == other.withDirs) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        boolean wasFilled = this.filled;
        this.fill();
        String str = this.type().toString() + " (" + this.asOfLocalized() + ") from " + String.valueOf(Path.of("", new String[0]).toAbsolutePath().relativize(this.root())) + " with " + this.stream().count() + " elements";
        if (!wasFilled) {
            this.clear();
        }
        this.filled = wasFilled;
        return str;
    }
}

