/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jdrupes.builder.api.Proxyable;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.ForwardingHandler;
import org.jdrupes.builder.core.ResourceObject;

public class DefaultResources<T extends Resource>
extends ResourceObject
implements Resources<T> {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Set<T> content = Collections.synchronizedSet(new LinkedHashSet());

    protected DefaultResources(ResourceType<?> type) {
        super(type);
    }

    static <T extends Resources<?>> T createResources(ResourceType<T> type) {
        return (T)((Resources)Proxy.newProxyInstance(type.rawType().getClassLoader(), new Class[]{type.rawType(), Proxyable.class}, (InvocationHandler)new ForwardingHandler(new DefaultResources<T>(type))));
    }

    @Override
    public Resources<T> add(T resource) {
        this.content.add(resource);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public Stream<T> stream() {
        return this.content.stream();
    }

    @Override
    public Resources<T> clear() {
        this.content.clear();
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.content);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof DefaultResources) {
            DefaultResources other = (DefaultResources)obj;
            if (Objects.equals(this.content, other.content)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.type().toString() + " (" + this.asOfLocalized() + ") with " + this.content.size() + " elements";
    }
}

