/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;

public class FutureStream<T extends Resource> {
    private static final ThreadLocal<Boolean> providerInvocationAllowed = ThreadLocal.withInitial(() -> false);
    private final Future<List<T>> source;

    public FutureStream(ExecutorService executor, ResourceProvider provider, ResourceRequest<T> requested) {
        this.source = executor.submit(() -> {
            try {
                providerInvocationAllowed.set(true);
                List list = provider.provide(requested).toList();
                return list;
            }
            finally {
                providerInvocationAllowed.set(false);
            }
        });
    }

    public static boolean isProviderInvocationAllowed() {
        Boolean allowed = providerInvocationAllowed.get();
        providerInvocationAllowed.set(false);
        return allowed;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            private Iterator<T> theIterator;

            private Iterator<T> iterator() {
                if (this.theIterator == null) {
                    try {
                        this.theIterator = FutureStream.this.source.get().iterator();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new BuildException(e);
                    }
                }
                return this.theIterator;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                this.iterator().forEachRemaining(action);
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (!this.iterator().hasNext()) {
                    return false;
                }
                action.accept(this.iterator().next());
                return true;
            }
        }, false);
    }
}

