/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.util.stream.Stream;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.AbstractGenerator;

public class ResourceCollector<T extends Resource>
extends AbstractGenerator {
    private final ResourceType<T> type;
    private final Resources<T> resources;

    public ResourceCollector(Project project, ResourceType<T> type) {
        super(project);
        this.type = type;
        this.resources = (Resources)this.project().newResource(new ResourceType<Resources<T>>(Resources.class, type){}, new Object[0]);
    }

    public final ResourceCollector<T> add(T resources) {
        this.resources.add(resources);
        return this;
    }

    public final ResourceCollector<T> add(Stream<T> resources) {
        this.resources.addAll(resources);
        return this;
    }

    public final Resources<T> resources() {
        return this.resources;
    }

    protected <R extends Resource> Stream<R> doProvide(ResourceRequest<R> requested) {
        if (!requested.type().containedType().isAssignableFrom(this.type)) {
            return Stream.empty();
        }
        return this.resources.stream();
    }
}

