/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jdrupes.builder.api.Proxyable;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.ForwardingHandler;

public abstract class ResourceObject
implements Resource,
Proxyable {
    private final ResourceType<?> type;

    protected ResourceObject() {
        this.type = new ResourceType(this.getClass(), null);
    }

    protected ResourceObject(ResourceType<?> type) {
        this.type = type;
    }

    static <T extends Resource> T createResource(ResourceType<T> type) {
        return (T)((Resource)Proxy.newProxyInstance(type.rawType().getClassLoader(), new Class[]{type.rawType(), Proxyable.class}, (InvocationHandler)new ForwardingHandler(new ResourceObject((ResourceType)type){})));
    }

    @Override
    public ResourceType<?> type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ResourceObject) {
            ResourceObject other = (ResourceObject)obj;
            if (Objects.equals(this.type(), other.type())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.type().toString() + " (" + this.asOfLocalized() + ")";
    }
}

