/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class StreamCollector<T> {
    private List<Stream<T>> sources = new ArrayList<Stream<T>>();
    private List<T> cache;
    private final boolean cached;

    public StreamCollector(boolean cached) {
        this.cached = cached;
    }

    @SafeVarargs
    public final StreamCollector<T> add(Stream<? extends T> ... sources) {
        if (this.sources == null) {
            throw new IllegalStateException("Cannot add sources after stream() has been called.");
        }
        this.sources.addAll(Arrays.asList(sources));
        return this;
    }

    @SafeVarargs
    public final StreamCollector<T> add(T ... items) {
        if (this.sources == null) {
            throw new IllegalStateException("Cannot add sources after stream() has been called.");
        }
        this.sources.add(Arrays.stream(items));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<T> stream() {
        StreamCollector streamCollector = this;
        synchronized (streamCollector) {
            Stream<Object> result;
            if (this.cache != null) {
                return this.cache.stream();
            }
            if (this.cached) {
                this.cache = this.sources.stream().flatMap(s -> s).toList();
                result = this.cache.stream();
            } else {
                result = this.sources.stream().flatMap(s -> s);
            }
            this.sources = null;
            return result;
        }
    }

    public static <T> StreamCollector<T> cached() {
        return new StreamCollector<T>(true);
    }

    public static <T> StreamCollector<T> cached(Stream<T> source) {
        StreamCollector<T> result = new StreamCollector<T>(true);
        result.add(source);
        return result;
    }

    public static <T> StreamCollector<T> uncached() {
        return new StreamCollector<T>(false);
    }

    public static <T> StreamCollector<T> uncached(Stream<T> source) {
        StreamCollector<T> result = new StreamCollector<T>(false);
        result.add(source);
        return result;
    }
}

