/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.eclipse;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.eclipse.EclipseConfiguration;
import org.jdrupes.builder.eclipse.FixCommentsFilter;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JavaCompiler;
import org.jdrupes.builder.java.JavaProject;
import org.jdrupes.builder.java.JavaResourceCollector;
import org.jdrupes.builder.java.JavaTypes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EclipseConfigurator
extends AbstractGenerator {
    public static final String GENERATED_BY = "Generated by JDrupes Builder";
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private BiConsumer<Document, Node> classpathAdaptor = (document, node) -> {};
    private Runnable configurationAdaptor = () -> {};
    private Consumer<Properties> jdtCorePrefsAdaptor = properties -> {};
    private Consumer<Properties> resourcesPrefsAdaptor = properties -> {};
    private Consumer<Properties> runtimePrefsAdaptor = properties -> {};
    private ProjectConfigurationAdaptor prjConfigAdaptor = (document, node, node2) -> {};

    public EclipseConfigurator(Project project) {
        super(project);
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(new ResourceType<EclipseConfiguration>(){})) {
            return Stream.empty();
        }
        this.project().directory().resolve(".settings").toFile().mkdirs();
        this.generateXmlFile(this::generateProjectConfiguration, ".project");
        if (this.project() instanceof JavaProject) {
            this.generateXmlFile(this::generateClasspathConfiguration, ".classpath");
        }
        this.generateResourcesPrefs();
        this.generateRuntimePrefs();
        if (this.project() instanceof JavaProject) {
            this.generateJdtCorePrefs();
        }
        this.configurationAdaptor.run();
        Stream<EclipseConfiguration> result = Stream.of(this.project().newResource(new ResourceType<EclipseConfiguration>(){}, this.project().directory()));
        return result;
    }

    private void generateXmlFile(Consumer<Document> generator, String name) {
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            generator.accept(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter out = Files.newBufferedWriter(this.project().directory().resolve(name), new OpenOption[0]);){
                transformer.transform(new DOMSource(doc), new StreamResult(out));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e) {
            throw new BuildException(e);
        }
    }

    protected void generateProjectConfiguration(Document doc) {
        Node prjDescr = doc.appendChild(doc.createElement("projectDescription"));
        prjDescr.appendChild(doc.createElement("name")).appendChild(doc.createTextNode(this.project().name()));
        prjDescr.appendChild(doc.createElement("comment")).appendChild(doc.createTextNode(GENERATED_BY));
        prjDescr.appendChild(doc.createElement("projects"));
        Node buildSpec = prjDescr.appendChild(doc.createElement("buildSpec"));
        Node natures = prjDescr.appendChild(doc.createElement("natures"));
        if (this.project() instanceof JavaProject) {
            Node cmd = buildSpec.appendChild(doc.createElement("buildCommand"));
            cmd.appendChild(doc.createElement("name")).appendChild(doc.createTextNode("org.eclipse.jdt.core.javabuilder"));
            cmd.appendChild(doc.createElement("arguments"));
            natures.appendChild(doc.createElement("nature")).appendChild(doc.createTextNode("org.eclipse.jdt.core.javanature"));
        }
        this.prjConfigAdaptor.accept(doc, buildSpec, natures);
    }

    public EclipseConfigurator adaptProjectConfiguration(ProjectConfigurationAdaptor adaptor) {
        this.prjConfigAdaptor = adaptor;
        return this;
    }

    protected void generateClasspathConfiguration(Document doc) {
        Node classpath = doc.appendChild(doc.createElement("classpath"));
        this.project().providers(Intend.Supply, new Intend[0]).filter(p -> p instanceof JavaCompiler).map(p -> (JavaCompiler)p).findFirst().ifPresent(jc -> {
            jc.sources().stream().map(FileTree::root).map(p -> this.project().relativize((Path)p)).forEach(p -> {
                Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
                entry.setAttribute("kind", "src");
                entry.setAttribute("path", p.toString());
            });
            Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
            entry.setAttribute("kind", "output");
            entry.setAttribute("path", this.project().relativize(jc.destination()).toString());
            jc.optionArgument("-target", "--target", "--release").ifPresentOrElse(v -> this.addSpecificJre(doc, classpath, (String)v), () -> this.addInheritedJre(doc, classpath));
        });
        this.project().providers(Intend.Supply, new Intend[0]).filter(p -> p instanceof JavaResourceCollector).map(p -> (JavaResourceCollector)p).findFirst().ifPresent(rc -> rc.resources().stream().map(FileTree::root).filter(p -> p.toFile().canRead()).map(p -> this.project().relativize((Path)p)).forEach(p -> {
            Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
            entry.setAttribute("kind", "src");
            entry.setAttribute("path", p.toString());
        }));
        this.collectContributing(this.project()).collect(Collectors.toSet()).stream().forEach(p -> {
            Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
            entry.setAttribute("kind", "src");
            entry.setAttribute("path", "/" + p.name());
            Node attributes = entry.appendChild(doc.createElement("attributes"));
            Element attribute = (Element)attributes.appendChild(doc.createElement("attribute"));
            attribute.setAttribute("without_test_code", "true");
        });
        this.project().provided(new ResourceRequest(JavaTypes.CompilationResourcesType)).filter(p -> p instanceof JarFile).map(jf -> (JarFile)jf).forEach(jf -> {
            File javadocJar;
            Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
            entry.setAttribute("kind", "lib");
            String jarPathName = jf.path().toString();
            entry.setAttribute("path", jarPathName);
            File sourcesJar = new File(jarPathName.replaceFirst("\\.jar$", "-sources.jar"));
            if (sourcesJar.canRead()) {
                entry.setAttribute("sourcepath", sourcesJar.getAbsolutePath());
            }
            if ((javadocJar = new File(jarPathName.replaceFirst("\\.jar$", "-javadoc.jar"))).canRead()) {
                Element attr = (Element)entry.appendChild(doc.createElement("attributes")).appendChild(doc.createElement("attribute"));
                attr.setAttribute("name", "javadoc_location");
                attr.setAttribute("value", "jar:file:" + javadocJar.getAbsolutePath() + "!/");
            }
        });
        this.classpathAdaptor.accept(doc, classpath);
    }

    private Stream<Project> collectContributing(Project project) {
        return project.providers(Intend.Consume, Intend.Forward, Intend.Expose).filter(p -> p instanceof Project).map(p -> (Project)p).map(p -> Stream.concat(Stream.of(p), this.collectContributing((Project)p))).flatMap(s -> s);
    }

    private void addSpecificJre(Document doc, Node classpath, String version) {
        Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
        entry.setAttribute("kind", "con");
        entry.setAttribute("path", "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-" + version);
        Node attributes = entry.appendChild(doc.createElement("attributes"));
        Element attribute = (Element)attributes.appendChild(doc.createElement("attribute"));
        attribute.setAttribute("name", "module");
        attribute.setAttribute("value", "true");
    }

    private void addInheritedJre(Document doc, Node classpath) {
        Element entry = (Element)classpath.appendChild(doc.createElement("classpathentry"));
        entry.setAttribute("kind", "con");
        entry.setAttribute("path", "org.eclipse.jdt.launching.JRE_CONTAINER");
        Node attributes = entry.appendChild(doc.createElement("attributes"));
        Element attribute = (Element)attributes.appendChild(doc.createElement("attribute"));
        attribute.setAttribute("name", "module");
        attribute.setAttribute("value", "true");
    }

    public EclipseConfigurator adaptClasspathConfiguration(BiConsumer<Document, Node> adaptor) {
        this.classpathAdaptor = adaptor;
        return this;
    }

    protected void generateResourcesPrefs() {
        Properties props = new Properties();
        props.setProperty("eclipse.preferences.version", "1");
        props.setProperty("encoding/<project>", "UTF-8");
        this.resourcesPrefsAdaptor.accept(props);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FixCommentsFilter out = new FixCommentsFilter(Files.newBufferedWriter(this.project().directory().resolve(".settings/org.eclipse.core.resources.prefs"), new OpenOption[0]), GENERATED_BY);){
                props.store(out, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot write eclipse settings: " + e.getMessage());
        }
    }

    public EclipseConfigurator adaptResourcePrefs(Consumer<Properties> adaptor) {
        this.resourcesPrefsAdaptor = adaptor;
        return this;
    }

    protected void generateRuntimePrefs() {
        Properties props = new Properties();
        props.setProperty("eclipse.preferences.version", "1");
        props.setProperty("line.separator", "\n");
        this.runtimePrefsAdaptor.accept(props);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FixCommentsFilter out = new FixCommentsFilter(Files.newBufferedWriter(this.project().directory().resolve(".settings/org.eclipse.core.runtime.prefs"), new OpenOption[0]), GENERATED_BY);){
                props.store(out, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot write eclipse settings: " + e.getMessage());
        }
    }

    public EclipseConfigurator adaptRuntimePrefs(Consumer<Properties> adaptor) {
        this.runtimePrefsAdaptor = adaptor;
        return this;
    }

    protected void generateJdtCorePrefs() {
        Properties props = new Properties();
        props.setProperty("eclipse.preferences.version", "1");
        this.project().providers(Intend.Supply, new Intend[0]).filter(p -> p instanceof JavaCompiler).map(p -> (JavaCompiler)p).findFirst().ifPresent(jc -> {
            jc.optionArgument("-target", "--target", "--release").ifPresent(v -> props.setProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", (String)v));
            jc.optionArgument("-source", "--source", "--release").ifPresent(v -> {
                props.setProperty("org.eclipse.jdt.core.compiler.source", (String)v);
                props.setProperty("org.eclipse.jdt.core.compiler.compliance", (String)v);
            });
        });
        this.jdtCorePrefsAdaptor.accept(props);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FixCommentsFilter out = new FixCommentsFilter(Files.newBufferedWriter(this.project().directory().resolve(".settings/org.eclipse.jdt.core.prefs"), new OpenOption[0]), GENERATED_BY);){
                props.store(out, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildException("Cannot write eclipse settings: " + e.getMessage());
        }
    }

    public EclipseConfigurator adaptJdtCorePrefs(Consumer<Properties> adaptor) {
        this.jdtCorePrefsAdaptor = adaptor;
        return this;
    }

    public EclipseConfigurator adaptConfiguration(Runnable adaptor) {
        this.configurationAdaptor = adaptor;
        return this;
    }

    @FunctionalInterface
    public static interface ProjectConfigurationAdaptor {
        public void accept(Document var1, Node var2, Node var3);
    }
}

