/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.eclipse;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class FixCommentsFilter
extends FilterWriter {
    private final StringBuilder buffer = new StringBuilder();

    public FixCommentsFilter(Writer out, String comment) {
        super(out);
        if (comment != null) {
            Arrays.stream(comment.split("\n")).map(String::trim).forEach(s -> {
                try {
                    out.append("# ").append((CharSequence)s).append(System.lineSeparator());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public void write(int chr) throws IOException {
        this.buffer.append((char)chr);
        this.checkBuffer();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.buffer.append(cbuf, off, len);
        this.checkBuffer();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.buffer.append(str, off, len);
        this.checkBuffer();
    }

    private void checkBuffer() throws IOException {
        int idx;
        while ((idx = this.buffer.indexOf("\n")) >= 0) {
            if (this.buffer.charAt(0) != '#') {
                this.out.write(this.buffer.substring(0, idx + 1));
            }
            this.buffer.delete(0, idx + 1);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.write(this.buffer.toString());
        this.out.close();
    }
}

