/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.io.File;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.java.ClasspathElement;
import org.jdrupes.builder.java.JavaTypes;

public class ClasspathScanner
extends AbstractGenerator {
    private final String path;

    public ClasspathScanner(Project project, String path) {
        super(project);
        this.path = path;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(JavaTypes.ClasspathElementType)) {
            return Stream.empty();
        }
        if (!JavaTypes.ClasspathType.rawType().equals(requested.type().rawType())) {
            return this.project().from(this).get(requested.widened(JavaTypes.ClasspathType.rawType()));
        }
        Stream<ClasspathElement> result = Stream.of(this.path.split(File.pathSeparator)).map(string -> Path.of(string, new String[0])).map(p -> this.project().directory().resolve((Path)p)).map(p -> {
            if (p.toFile().isDirectory()) {
                return this.project().newResource(JavaTypes.ClassTreeType, p.toAbsolutePath());
            }
            return this.project().newResource(JavaTypes.JarFileType, p.toAbsolutePath());
        }).filter(e -> requested.includes(e.type()));
        return result;
    }
}

