/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdrupes.builder.api.IOResource;
import org.jdrupes.builder.core.ResourceObject;

public class JarFileEntry
extends ResourceObject
implements IOResource {
    private final JarFile jarFile;
    private final JarEntry entry;

    public JarFileEntry(JarFile jarFile, JarEntry entry) {
        this.jarFile = jarFile;
        this.entry = entry;
    }

    @Override
    public Instant asOf() {
        return this.entry.getLastModifiedTime().toInstant();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return this.jarFile.getInputStream(this.entry);
    }

    @Override
    public OutputStream outputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.entry.getName(), this.jarFile.getName());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof JarFileEntry) {
            JarFileEntry other = (JarFileEntry)obj;
            if (Objects.equals(this.entry.getName(), other.entry.getName()) && Objects.equals(this.jarFile.getName(), other.jarFile.getName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.jarFile.getName() + "!" + this.entry.getName() + " (" + this.asOfLocalized() + ")";
    }
}

