/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.IOResource;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.core.StreamCollector;
import org.jdrupes.builder.java.JarFile;

public class JarGenerator
extends AbstractGenerator {
    private final ResourceType<? extends JarFile> jarType;
    private Supplier<Path> destination = () -> this.project().buildDirectory().resolve("libs");
    private Supplier<String> jarName = () -> this.project().name() + "-" + String.valueOf(this.project().get(Project.Properties.Version)) + ".jar";
    private final StreamCollector<Map.Entry<Attributes.Name, String>> attributes = StreamCollector.cached();
    private final StreamCollector<Map.Entry<Path, ? extends IOResource>> entryStreams = StreamCollector.cached();
    private final StreamCollector<FileTree<?>> fileTrees = StreamCollector.cached();

    public JarGenerator(Project project, ResourceType<? extends JarFile> jarType) {
        super(project);
        this.jarType = jarType;
    }

    public Path destination() {
        return this.destination.get();
    }

    public JarGenerator destination(Path destination) {
        this.destination = () -> this.project().buildDirectory().resolve(destination);
        return this;
    }

    public JarGenerator destination(Supplier<Path> destination) {
        this.destination = destination;
        return this;
    }

    public String jarName() {
        return this.jarName.get();
    }

    public JarGenerator jarName(Supplier<String> jarName) {
        this.jarName = jarName;
        return this;
    }

    public JarGenerator jarName(String jarName) {
        return this.jarName(() -> jarName);
    }

    public JarGenerator attributes(Stream<Map.Entry<Attributes.Name, String>> attributes) {
        this.attributes.add(attributes);
        return this;
    }

    @SafeVarargs
    public final JarGenerator attributes(Map.Entry<Attributes.Name, String> ... attributes) {
        this.attributes.add(Arrays.stream(attributes));
        return this;
    }

    public JarGenerator addEntries(Stream<? extends Map.Entry<Path, ? extends IOResource>> entries) {
        this.entryStreams.add(entries);
        return this;
    }

    public JarGenerator addTrees(Stream<? extends FileTree<?>> trees) {
        this.fileTrees.add(trees);
        return this;
    }

    public JarGenerator add(FileTree<?> ... trees) {
        this.addTrees(Arrays.stream(trees));
        return this;
    }

    public JarGenerator add(Map.Entry<Path, ? extends IOResource> ... entries) {
        this.addEntries(Arrays.stream(entries));
        return this;
    }

    protected void buildJar(JarFile jarResource) {
        ConcurrentHashMap<Path, Resources<IOResource>> contents = new ConcurrentHashMap<Path, Resources<IOResource>>();
        this.collectContents(contents);
        this.resolveDuplicates(contents);
        Optional<IOResource> newer = contents.values().stream().map(r -> r.stream().findFirst().stream()).flatMap(s -> s).filter(r -> r.asOf().isAfter(jarResource.asOf())).findAny();
        if (newer.isEmpty()) {
            this.log.fine(() -> "Existing " + this.jarName() + " is up to date.");
            return;
        }
        this.log.fine(() -> "Rebuilding " + this.jarName() + ", is older than " + String.valueOf(newer.get()));
        this.log.info(() -> "Building " + this.jarName() + " in " + this.project().name());
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        this.attributes.stream().forEach(e -> {
            Object object = attributes.put(e.getKey(), e.getValue());
        });
        try {
            Files.deleteIfExists(jarResource.path());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (JarOutputStream jos = new JarOutputStream(Files.newOutputStream(jarResource.path(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), manifest);){
                for (Map.Entry<Path, Resources<IOResource>> entry : contents.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    String entryName = StreamSupport.stream(entry.getKey().spliterator(), false).map(Path::toString).collect(Collectors.joining("/"));
                    JarEntry jarEntry = new JarEntry(entryName);
                    jarEntry.setTime(entry.getValue().stream().findFirst().get().asOf().toEpochMilli());
                    jos.putNextEntry(jarEntry);
                    Throwable throwable2 = null;
                    Object var14_19 = null;
                    try (InputStream input = entry.getValue().stream().findFirst().get().inputStream();){
                        input.transferTo(jos);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            throw new BuildException(e2);
        }
    }

    protected void collectContents(Map<Path, Resources<IOResource>> contents) {
        this.entryStreams.stream().forEach(entry -> contents.computeIfAbsent((Path)entry.getKey(), path -> this.project().newResource(ResourceType.IOResourcesType, new Object[0])).add((IOResource)entry.getValue()));
        ((Stream)this.fileTrees.stream().parallel()).forEach(t -> this.collect(contents, (FileTree<?>)t));
    }

    protected void collect(Map<Path, Resources<IOResource>> collected, FileTree<?> fileTree) {
        Path root = fileTree.root();
        fileTree.stream().forEach(file -> {
            Path relPath = root.relativize(file.path());
            collected.computeIfAbsent(relPath, path -> this.project().newResource(ResourceType.IOResourcesType, new Object[0])).add(file);
        });
    }

    protected void resolveDuplicates(Map<Path, Resources<IOResource>> entries) {
        entries.entrySet().parallelStream().forEach(item -> {
            Resources resources = (Resources)item.getValue();
            if (resources.stream().count() == 1L) {
                return;
            }
            Path entryName = (Path)item.getKey();
            resources.stream().reduce((a, b) -> {
                this.log.warning(() -> "Entry " + String.valueOf(entryName) + " from " + String.valueOf(a) + " duplicates entry from " + String.valueOf(b) + " and is skipped.");
                return a;
            });
        });
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(this.jarType) && !requested.includes(ResourceType.CleanlinessType)) {
            return Stream.empty();
        }
        Path destDir = this.destination();
        if (!destDir.toFile().exists() && !destDir.toFile().mkdirs()) {
            throw new BuildException("Cannot create directory " + String.valueOf(destDir));
        }
        JarFile jarResource = this.project().newResource(this.jarType, destDir.resolve(this.jarName()));
        if (requested.includes(ResourceType.CleanlinessType)) {
            jarResource.delete();
            return Stream.empty();
        }
        this.buildJar(jarResource);
        return Stream.of(jarResource);
    }
}

