/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.java.ClassTree;
import org.jdrupes.builder.java.ClasspathElement;
import org.jdrupes.builder.java.JavaSourceFile;
import org.jdrupes.builder.java.JavaTool;
import org.jdrupes.builder.java.JavaTypes;

public class JavaCompiler
extends JavaTool {
    private final Resources<FileTree<JavaSourceFile>> sources = this.project().newResource(new ResourceType<Resources<FileTree<JavaSourceFile>>>(){}, new Object[0]);
    private Path destination = Path.of("classes", new String[0]);

    public JavaCompiler(Project project) {
        super(project);
    }

    public Path destination() {
        return this.project().buildDirectory().resolve(this.destination);
    }

    public JavaCompiler destination(Path destination) {
        this.destination = destination;
        return this;
    }

    public final JavaCompiler addSources(FileTree<JavaSourceFile> sources) {
        this.sources.add(sources);
        return this;
    }

    public final JavaCompiler addSources(Path directory, String pattern) {
        this.addSources(this.project().newResource(JavaTypes.JavaSourceTreeType, directory, pattern));
        return this;
    }

    public final JavaCompiler addSources(Stream<FileTree<JavaSourceFile>> sources) {
        this.sources.addAll(sources);
        return this;
    }

    public Resources<FileTree<JavaSourceFile>> sources() {
        return this.sources;
    }

    private Collection<Path> sourcePaths() {
        return this.sources.stream().map(Resources::stream).flatMap(Function.identity()).map(FileResource::path).collect(Collectors.toList());
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (requested.includes(JavaTypes.JavaSourceTreeType)) {
            Stream<FileTree<JavaSourceFile>> result = this.sources.stream();
            return result;
        }
        if (!requested.includes(JavaTypes.ClassTreeType) && !requested.includes(ResourceType.CleanlinessType)) {
            return Stream.empty();
        }
        if (!JavaTypes.ClasspathType.rawType().equals(requested.type().rawType())) {
            return this.project().from(this).get(requested.widened(JavaTypes.ClasspathType.rawType()));
        }
        Path destDir = this.project().buildDirectory().resolve(this.destination);
        ClassTree classSet = this.project().newResource(JavaTypes.ClassTreeType, destDir);
        if (requested.includes(ResourceType.CleanlinessType)) {
            classSet.delete();
            return Stream.empty();
        }
        Resources<ClasspathElement> cpResources = this.project().newResource(JavaTypes.ClasspathType, new Object[0]).addAll(this.project().provided(new ResourceRequest(JavaTypes.CompilationResourcesType)));
        this.log.finest(() -> "Compiling in " + String.valueOf(this.project()) + " with classpath " + cpResources.stream().map(e -> e.toPath().toString()).collect(Collectors.joining(File.pathSeparator)));
        Instant classesAsOf = classSet.asOf();
        if (this.sources.asOf().isAfter(classesAsOf) || cpResources.asOf().isAfter(classesAsOf) || classSet.stream().count() < this.sources.stream().flatMap(Resources::stream).map(FileResource::path).filter(p -> p.toString().endsWith(".java") && !p.endsWith("package-info.java") && !p.endsWith("module-info.java")).count()) {
            classSet.delete();
            this.compile(cpResources, destDir);
        } else {
            this.log.fine(() -> "Classes in " + String.valueOf(this.project()) + " are up to date.");
        }
        classSet.clear();
        Stream<ClassTree> result = Stream.of(classSet);
        return result;
    }

    private void compile(Resources<ClasspathElement> cpResources, Path destDir) {
        this.log.info(() -> "Compiling Java in project " + this.project().name());
        String classpath = cpResources.stream().map(e -> e.toPath().toString()).collect(Collectors.joining(File.pathSeparator));
        javax.tools.JavaCompiler javac = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (StandardJavaFileManager fileManager = javac.getStandardFileManager(diagnostics, null, null);){
                    Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromPaths(this.sourcePaths());
                    ArrayList<String> allOptions = new ArrayList<String>(this.options());
                    allOptions.addAll(List.of("-d", destDir.toString(), "-cp", classpath, "-encoding", this.project().get(Project.Properties.Encoding).toString()));
                    if (!javac.getTask(null, fileManager, null, List.of("-d", destDir.toString(), "-cp", classpath), null, compilationUnits).call().booleanValue()) {
                        throw new BuildException("Compilation failed");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e2) {
                this.log.log(Level.SEVERE, () -> "Project " + this.project().name() + ": Problem compiling Java: " + e2.getMessage());
                throw new BuildException(e2);
            }
        }
        finally {
            this.logDiagnostics(diagnostics);
        }
    }
}

