/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.nio.file.Path;
import java.util.Optional;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.CoreResourceFactory;
import org.jdrupes.builder.java.ClassTree;
import org.jdrupes.builder.java.DefaultClassTree;
import org.jdrupes.builder.java.DefaultJarFile;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JavaResourceTree;
import org.jdrupes.builder.java.JavaTypes;

public class JavaResourceFactory
implements ResourceFactory {
    @Override
    public <T extends Resource> Optional<T> newResource(ResourceType<T> type, Project project, Object ... args) {
        if (JavaTypes.ClassTreeType.isAssignableFrom(type) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(ClassTree.class, type.rawType())) {
            return Optional.of(DefaultClassTree.createClassTree(type, project, (Path)args[0]));
        }
        if (JavaTypes.JarFileType.isAssignableFrom(type) && type.rawType().getSuperclass() == null && !CoreResourceFactory.addsMethod(JarFile.class, type.rawType())) {
            return Optional.of(DefaultJarFile.createJarFile(type, (Path)args[0]));
        }
        if (JavaResourceTree.class.equals(type.rawType())) {
            return Optional.of(new JavaResourceTree(project, (Path)args[0], (String)args[1]));
        }
        return Optional.empty();
    }
}

