/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.core.AbstractGenerator;

public abstract class JavaTool
extends AbstractGenerator {
    private final List<String> options = new ArrayList<String>();

    public JavaTool(Project project) {
        super(project);
    }

    public JavaTool options(Stream<String> options) {
        this.options.addAll(options.toList());
        return this;
    }

    public JavaTool options(String ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    public List<String> options() {
        return this.options;
    }

    public Optional<String> optionArgument(String ... names) {
        Iterator<String> itr = this.options.iterator();
        if (itr.hasNext()) {
            String opt = itr.next();
            if (Arrays.stream(names).anyMatch(opt::equals) && itr.hasNext()) {
                return Optional.of(itr.next());
            }
        }
        return Optional.empty();
    }

    protected void logDiagnostic(Diagnostic<? extends JavaFileObject> diagnostic) {
        String msg = diagnostic.getSource() == null ? diagnostic.getMessage(Locale.ENGLISH) : String.format("%s:%d: %s", this.project().rootProject().directory().relativize(Path.of(diagnostic.getSource().toUri().getPath(), new String[0])), diagnostic.getLineNumber(), diagnostic.getMessage(null));
        Level level = switch (diagnostic.getKind()) {
            case Diagnostic.Kind.ERROR -> Level.SEVERE;
            case Diagnostic.Kind.WARNING -> Level.WARNING;
            case Diagnostic.Kind.MANDATORY_WARNING -> Level.WARNING;
            default -> Level.INFO;
        };
        this.log.log(level, () -> msg);
    }

    protected void logDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics) {
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            this.logDiagnostic(diagnostic);
        }
    }
}

