/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.StreamCollector;
import org.jdrupes.builder.java.ClassTree;
import org.jdrupes.builder.java.ClasspathElement;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JavaSourceFile;
import org.jdrupes.builder.java.JavaTool;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.java.JavadocDirectory;

public class Javadoc
extends JavaTool {
    private final StreamCollector<FileTree<JavaSourceFile>> sources = StreamCollector.cached();
    private Path destination = Path.of("doc", new String[0]);
    private final Resources<ClasspathElement> tagletpath;
    private final List<String> taglets = new ArrayList<String>();

    public Javadoc(Project project) {
        super(project);
        this.tagletpath = this.project().newResource(new ResourceType<Resources<ClasspathElement>>(){}, new Object[0]);
    }

    public Path destination() {
        return this.destination;
    }

    public Javadoc destination(Path destination) {
        this.destination = destination;
        return this;
    }

    @SafeVarargs
    public final Javadoc addSources(FileTree<JavaSourceFile> ... sources) {
        this.sources.add(Arrays.stream(sources));
        return this;
    }

    public final Javadoc addSources(Path directory, String pattern) {
        this.addSources(this.project().newResource(JavaTypes.JavaSourceTreeType, directory, pattern));
        return this;
    }

    public final Javadoc addSources(Stream<FileTree<JavaSourceFile>> sources) {
        this.sources.add(sources);
        return this;
    }

    private Collection<Path> sourcePaths() {
        return this.sources.stream().map(Resources::stream).flatMap(Function.identity()).map(FileResource::path).collect(Collectors.toSet());
    }

    public Javadoc tagletpath(Stream<ClasspathElement> classpathElements) {
        this.tagletpath.addAll(classpathElements);
        return this;
    }

    public Javadoc taglets(Stream<String> taglets) {
        this.taglets.addAll(taglets.toList());
        return this;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(JavaTypes.JavadocDirectoryType) && !requested.includes(ResourceType.CleanlinessType)) {
            return Stream.empty();
        }
        Path destDir = this.project().buildDirectory().resolve(this.destination);
        ClassTree generated = this.project().newResource(JavaTypes.ClassTreeType, destDir, "**/*");
        if (requested.includes(ResourceType.CleanlinessType)) {
            generated.delete();
            destDir.toFile().delete();
            return Stream.empty();
        }
        DocumentationTool javadoc = ToolProvider.getSystemDocumentationTool();
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (StandardJavaFileManager fileManager = javadoc.getStandardFileManager(diagnostics, null, null);){
                    if (this.options().contains("-d")) {
                        new BuildException(String.valueOf(this.project()) + ": Specifying the destination directory with options() is not allowed.");
                    }
                    ArrayList<String> allOptions = new ArrayList<String>(this.options());
                    allOptions.addAll(List.of("-d", destDir.toString()));
                    String tagletPath = this.tagletPath();
                    if (!tagletPath.isEmpty()) {
                        allOptions.addAll(List.of("-tagletpath", tagletPath));
                    }
                    for (String taglet : this.taglets) {
                        allOptions.addAll(List.of("-taglet", taglet));
                    }
                    Iterable<? extends JavaFileObject> sourceFiles = fileManager.getJavaFileObjectsFromPaths(this.sourcePaths());
                    if (!javadoc.getTask(null, fileManager, diagnostics, null, allOptions, sourceFiles).call().booleanValue()) {
                        throw new BuildException("Documentation generation failed");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, () -> "Project " + this.project().name() + ": Problem compiling Java: " + e.getMessage());
                throw new BuildException(e);
            }
        }
        finally {
            this.logDiagnostics(diagnostics);
        }
        Stream<JavadocDirectory> result = Stream.of(this.project().newResource(JavaTypes.JavadocDirectoryType, destDir));
        return result;
    }

    private String tagletPath() {
        return this.tagletpath.stream().mapMulti((e, consumer) -> {
            if (e instanceof ClassTree) {
                ClassTree classTree = (ClassTree)e;
                consumer.accept(classTree.root());
            } else if (e instanceof JarFile) {
                JarFile jarFile = (JarFile)e;
                consumer.accept(jarFile.path());
            }
        }).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }
}

