/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.java;

import java.nio.file.Path;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.stream.Stream;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.IOResource;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceRetriever;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.StreamCollector;
import org.jdrupes.builder.java.ClassTree;
import org.jdrupes.builder.java.JarGenerator;
import org.jdrupes.builder.java.JavaResourceTree;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.java.LibraryJarFile;

public class LibraryGenerator
extends JarGenerator
implements ResourceRetriever {
    private final StreamCollector<ResourceProvider> providers = StreamCollector.cached();
    private String mainClass;

    public LibraryGenerator(Project project) {
        super(project, JavaTypes.LibraryJarFileType);
    }

    public String mainClass() {
        return this.mainClass;
    }

    public LibraryGenerator mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    @Override
    public LibraryGenerator from(ResourceProvider ... providers) {
        this.from((Stream)Stream.of(providers));
        return this;
    }

    @Override
    public LibraryGenerator from(Stream<ResourceProvider> providers) {
        this.providers.add(providers.filter(p -> !p.equals(this)));
        return this;
    }

    protected StreamCollector<ResourceProvider> providers() {
        return this.providers;
    }

    @Override
    protected void collectContents(Map<Path, Resources<IOResource>> contents) {
        super.collectContents(contents);
        if (this.mainClass() != null) {
            this.attributes(Map.entry(Attributes.Name.MAIN_CLASS, this.mainClass()));
        }
        this.collectFromProviders(contents);
    }

    protected void collectFromProviders(Map<Path, Resources<IOResource>> contents) {
        ((Stream)this.project().getFrom(this.providers().stream(), new ResourceRequest<ClassTree>(new ResourceType<Resources<ClassTree>>(){})).parallel()).forEach(t -> this.collect(contents, (FileTree<?>)t));
        ((Stream)this.project().getFrom(this.providers().stream(), new ResourceRequest<JavaResourceTree>(new ResourceType<Resources<JavaResourceTree>>(){})).parallel()).forEach(t -> this.collect(contents, (FileTree<?>)t));
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        LibraryJarFile jarResource;
        if (!requested.includes(JavaTypes.LibraryJarFileType) && !requested.includes(ResourceType.CleanlinessType)) {
            return Stream.empty();
        }
        if (JavaTypes.AppJarFileType.isAssignableFrom(requested.type().containedType()) && this.mainClass() == null) {
            throw new BuildException("Main class must be set for " + this.name() + " in " + String.valueOf(this.project()));
        }
        Path destDir = this.destination();
        if (!destDir.toFile().exists() && !destDir.toFile().mkdirs()) {
            throw new BuildException("Cannot create directory " + String.valueOf(destDir));
        }
        LibraryJarFile libraryJarFile = jarResource = JavaTypes.AppJarFileType.isAssignableFrom(requested.type().containedType()) ? (LibraryJarFile)this.project().newResource(JavaTypes.AppJarFileType, destDir.resolve(this.jarName())) : this.project().newResource(JavaTypes.LibraryJarFileType, destDir.resolve(this.jarName()));
        if (requested.includes(ResourceType.CleanlinessType)) {
            jarResource.delete();
            return Stream.empty();
        }
        this.buildJar(jarResource);
        return Stream.of(jarResource);
    }
}

