/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.mvnrepo;

import java.util.Objects;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.ResourceObject;
import org.jdrupes.builder.mvnrepo.MvnRepoResource;

public class DefaultMvnRepoResource
extends ResourceObject
implements MvnRepoResource {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public DefaultMvnRepoResource(ResourceType<? extends MvnRepoResource> type, String coordinate) {
        super(type);
        String[] parts = coordinate.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid maven coordinate: " + coordinate);
        }
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.version = parts[2];
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String artifactId() {
        return this.artifactId;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.artifactId, this.groupId, this.version);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof DefaultMvnRepoResource) {
            DefaultMvnRepoResource other = (DefaultMvnRepoResource)obj;
            if (Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.version, other.version)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.type().toString() + " " + this.coordinates();
    }
}

