/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.mvnrepo;

import eu.maveniverse.maven.mima.context.Context;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.java.JavadocJarFile;
import org.jdrupes.builder.java.LibraryJarFile;
import org.jdrupes.builder.java.SourcesJarFile;
import org.jdrupes.builder.mvnrepo.MvnProperties;
import org.jdrupes.builder.mvnrepo.MvnRepoLookup;
import org.jdrupes.builder.mvnrepo.MvnRepoTypes;
import org.jdrupes.builder.mvnrepo.PomFile;

public class MvnPublisher
extends AbstractGenerator {
    private URI uploadUri;
    private URI snapshotUri;
    private String repoUser;
    private String repoPass;
    private String signingKeyRing;
    private String signingKeyId;
    private String signingPassword;
    private JcaPGPContentSignerBuilder signerBuilder;
    private PGPPrivateKey privateKey;
    private PGPPublicKey publicKey;
    private Supplier<Path> artifactDirectory = () -> this.project().buildDirectory().resolve("publications/maven");
    private boolean keepSubArtifacts;
    private boolean publishAutomatically;

    public MvnPublisher(Project project) {
        super(project);
        this.uploadUri = URI.create("https://central.sonatype.com/api/v1/publisher/upload");
        this.snapshotUri = URI.create("https://central.sonatype.com/repository/maven-snapshots/");
    }

    public MvnPublisher uploadUri(URI uri) {
        this.uploadUri = uri;
        return this;
    }

    public URI uploadUri() {
        return this.uploadUri;
    }

    public MvnPublisher snapshotRepository(URI uri) {
        this.snapshotUri = uri;
        return this;
    }

    public URI snapshotRepository() {
        return this.snapshotUri;
    }

    public MvnPublisher credentials(String user, String pass) {
        this.repoUser = user;
        this.repoPass = pass;
        return this;
    }

    public MvnPublisher signWith(String secretKeyRing, String keyId, String password) {
        this.signingKeyRing = secretKeyRing;
        this.signingKeyId = keyId;
        this.signingPassword = password;
        return this;
    }

    public MvnPublisher keepSubArtifacts() {
        this.keepSubArtifacts = true;
        return this;
    }

    public MvnPublisher publishAutomatically() {
        this.publishAutomatically = true;
        return this;
    }

    public Path artifactDirectory() {
        return this.artifactDirectory.get();
    }

    public MvnPublisher artifactDirectory(Path directory) {
        if (directory == null) {
            this.artifactDirectory = () -> null;
            return this;
        }
        this.artifactDirectory = () -> this.project().buildDirectory().resolve(directory);
        return this;
    }

    public MvnPublisher artifactDirectory(Supplier<Path> directory) {
        this.artifactDirectory = directory;
        return this;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(MvnRepoTypes.MvnPublicationType)) {
            return Stream.empty();
        }
        PomFile pomResource = this.resourceCheck(this.project().supplied(ResourceRequest.requestFor(PomFile.class)), "POM file");
        if (pomResource == null) {
            return Stream.empty();
        }
        LibraryJarFile jarResource = this.resourceCheck(this.project().getFrom(this.project().providers(Intend.Expose, Intend.Forward), ResourceRequest.requestFor(LibraryJarFile.class)), "jar file");
        if (jarResource == null) {
            return Stream.empty();
        }
        Iterator srcsIter = this.project().supplied(ResourceRequest.requestFor(SourcesJarFile.class)).iterator();
        SourcesJarFile srcsFile = null;
        if (srcsIter.hasNext()) {
            srcsFile = (SourcesJarFile)srcsIter.next();
            if (srcsIter.hasNext()) {
                this.log.severe(() -> "More than one sources jar resources found.");
                return Stream.empty();
            }
        }
        Iterator jdIter = this.project().supplied(ResourceRequest.requestFor(JavadocJarFile.class)).iterator();
        JavadocJarFile jdFile = null;
        if (jdIter.hasNext()) {
            jdFile = (JavadocJarFile)jdIter.next();
            if (jdIter.hasNext()) {
                this.log.severe(() -> "More than one javadoc jar resources found.");
                return Stream.empty();
            }
        }
        Stream<?> result = this.deploy(pomResource, jarResource, srcsFile, jdFile);
        return result;
    }

    private <T extends Resource> T resourceCheck(Stream<T> resources, String name) {
        Iterator iter = resources.iterator();
        if (!iter.hasNext()) {
            this.log.severe(() -> "No " + name + " resource available.");
            return null;
        }
        Resource result = (Resource)iter.next();
        if (iter.hasNext()) {
            this.log.severe(() -> "More than one " + name + " resource found.");
            return null;
        }
        return (T)result;
    }

    private Stream<?> deploy(PomFile pomResource, LibraryJarFile jarResource, SourcesJarFile srcsJar, JavadocJarFile javadocJar) {
        Artifact mainArtifact;
        try {
            mainArtifact = this.mainArtifact(pomResource);
        }
        catch (ModelBuildingException e) {
            throw new BuildException("Cannot build model from POM: " + e.getMessage(), e);
        }
        if (this.artifactDirectory() != null) {
            this.artifactDirectory().toFile().mkdirs();
        }
        ArrayList<Deployable> toDeploy = new ArrayList<Deployable>();
        this.addWithGenerated(toDeploy, new SubArtifact(mainArtifact, "", "pom", pomResource.path().toFile()));
        this.addWithGenerated(toDeploy, new SubArtifact(mainArtifact, "", "jar", jarResource.path().toFile()));
        if (srcsJar != null) {
            this.addWithGenerated(toDeploy, new SubArtifact(mainArtifact, "sources", "jar", srcsJar.path().toFile()));
        }
        if (javadocJar != null) {
            this.addWithGenerated(toDeploy, new SubArtifact(mainArtifact, "javadoc", "jar", javadocJar.path().toFile()));
        }
        try {
            try {
                if (mainArtifact.isSnapshot()) {
                    this.deploySnapshot(toDeploy);
                } else {
                    this.deployRelease(mainArtifact, toDeploy);
                }
            }
            catch (DeploymentException e) {
                throw new BuildException("Deployment failed for " + String.valueOf(mainArtifact), e);
            }
        }
        catch (Throwable throwable) {
            if (!this.keepSubArtifacts) {
                toDeploy.stream().filter(Deployable::temporary).forEach(d -> d.artifact().getFile().delete());
            }
            throw throwable;
        }
        if (!this.keepSubArtifacts) {
            toDeploy.stream().filter(Deployable::temporary).forEach(d -> d.artifact().getFile().delete());
        }
        return Stream.of(this.project().newResource(MvnRepoTypes.MvnPublicationType, mainArtifact.getGroupId() + ":" + mainArtifact.getArtifactId() + ":" + mainArtifact.getVersion()));
    }

    private Artifact mainArtifact(PomFile pomResource) throws ModelBuildingException {
        File pomFile = pomResource.path().toFile();
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest().setPomFile(pomFile);
        Model model = new DefaultModelBuilderFactory().newInstance().build(req).getEffectiveModel();
        return new DefaultArtifact(model.getGroupId(), model.getArtifactId(), "jar", model.getVersion());
    }

    private void addWithGenerated(List<Deployable> toDeploy, Artifact artifact) {
        toDeploy.add(new Deployable(artifact, false));
        Path artifactFile = artifact.getFile().toPath();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream fis = Files.newInputStream(artifactFile, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = fis.read(buffer)) >= 0) {
                    md5.update(buffer, 0, read);
                    sha1.update(buffer, 0, read);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            String fileName = artifactFile.getFileName().toString();
            Path md5Path = this.destinationPath(artifactFile, fileName + ".md5");
            Files.writeString(md5Path, (CharSequence)MvnPublisher.toHex(md5.digest()), new OpenOption[0]);
            toDeploy.add(new Deployable(new SubArtifact(artifact, "*", "*.md5", md5Path.toFile()), true));
            Path sha1Path = this.destinationPath(artifactFile, fileName + ".sha1");
            Files.writeString(sha1Path, (CharSequence)MvnPublisher.toHex(sha1.digest()), new OpenOption[0]);
            toDeploy.add(new Deployable(new SubArtifact(artifact, "*", "*.sha1", sha1Path.toFile()), true));
            Path sigPath = this.signResource(artifactFile);
            toDeploy.add(new Deployable(new SubArtifact(artifact, "*", "*.asc", sigPath.toFile()), true));
        }
        catch (IOException | NoSuchAlgorithmException | PGPException e) {
            throw new BuildException(e);
        }
    }

    private Path destinationPath(Path base, String fileName) {
        Path dir = this.artifactDirectory();
        if (dir == null) {
            base.resolveSibling(fileName);
        }
        return dir.resolve(fileName);
    }

    private static String toHex(byte[] bytes) {
        char[] hexDigits = "0123456789abcdef".toCharArray();
        char[] result = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            int unsigned = bytes[i] & 0xFF;
            result[i * 2] = hexDigits[unsigned >>> 4];
            result[i * 2 + 1] = hexDigits[unsigned & 0xF];
            ++i;
        }
        return new String(result);
    }

    private void initSigning() throws FileNotFoundException, IOException, PGPException {
        if (this.signerBuilder != null) {
            return;
        }
        String keyRingFileName = Optional.ofNullable(this.signingKeyRing).orElse(this.project().context().property("signing.secretKeyRingFile"));
        String keyId = Optional.ofNullable(this.signingKeyId).orElse(this.project().context().property("signing.keyId"));
        char[] passphrase = Optional.ofNullable(this.signingPassword).orElse(this.project().context().property("signing.password")).toCharArray();
        if (keyRingFileName == null || keyId == null || passphrase == null) {
            this.log.warning(() -> "Cannot sign artifacts: properties not set.");
            return;
        }
        Security.addProvider(new BouncyCastleProvider());
        PGPSecretKeyRingCollection secretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(Files.newInputStream(Path.of(keyRingFileName, new String[0]), new OpenOption[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKey secretKey = secretKeyRingCollection.getSecretKey(Long.parseUnsignedLong(keyId, 16));
        this.publicKey = secretKey.getPublicKey();
        this.privateKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(passphrase));
        this.signerBuilder = new JcaPGPContentSignerBuilder(this.publicKey.getAlgorithm(), 8).setProvider("BC");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path signResource(Path resource) throws PGPException, IOException {
        this.initSigning();
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)this.signerBuilder, this.publicKey);
        signatureGenerator.init(0, this.privateKey);
        Path sigPath = this.destinationPath(resource, String.valueOf(resource.getFileName()) + ".asc");
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedInputStream fileInput = new BufferedInputStream(Files.newInputStream(resource, new OpenOption[0]));
            try {
                try (ArmoredOutputStream sigOut = new ArmoredOutputStream(Files.newOutputStream(sigPath, new OpenOption[0]));){
                    int read;
                    byte[] buffer = new byte[8192];
                    while ((read = ((InputStream)fileInput).read(buffer)) >= 0) {
                        signatureGenerator.update(buffer, 0, read);
                    }
                    PGPSignature signature = signatureGenerator.generate();
                    signature.encode(sigOut);
                }
                if (fileInput == null) return sigPath;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileInput == null) throw throwable;
                ((InputStream)fileInput).close();
                throw throwable;
            }
            ((InputStream)fileInput).close();
            return sigPath;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void deploySnapshot(List<Deployable> toDeploy) throws DeploymentException {
        Context context = MvnRepoLookup.rootContext();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(context.repositorySystemSession());
        final AtomicBoolean startMsgLogged = new AtomicBoolean(false);
        session.setRepositoryListener(new AbstractRepositoryListener(){

            @Override
            public void artifactDeploying(RepositoryEvent event) {
                if (!startMsgLogged.getAndSet(true)) {
                    MvnPublisher.this.log.info(() -> "Start deploying artifacts...");
                }
            }

            @Override
            public void artifactDeployed(RepositoryEvent event) {
                if (!"jar".equals(event.getArtifact().getExtension())) {
                    return;
                }
                MvnPublisher.this.log.info(() -> "Deployed: " + String.valueOf(event.getArtifact()));
            }

            @Override
            public void metadataDeployed(RepositoryEvent event) {
                MvnPublisher.this.log.info(() -> "Deployed: " + String.valueOf(event.getMetadata()));
            }
        });
        String user = Optional.ofNullable(this.repoUser).orElse(this.project().context().property("mvnrepo.user"));
        String password = Optional.ofNullable(this.repoPass).orElse(this.project().context().property("mvnrepo.password"));
        RemoteRepository repo = new RemoteRepository.Builder("mine", "default", this.snapshotUri.toString()).setAuthentication(new AuthenticationBuilder().addUsername(user).addPassword(password).build()).build();
        DeployRequest deployReq = new DeployRequest().setRepository(repo);
        toDeploy.stream().map(d -> d.artifact).forEach(deployReq::addArtifact);
        context.repositorySystem().deploy(session, deployReq);
    }

    private void deployRelease(Artifact mainArtifact, List<Deployable> toDeploy) {
        Throwable throwable;
        String zipName = String.valueOf(Optional.ofNullable(this.project().get(MvnProperties.ArtifactId)).orElse(this.project().name())) + "-" + mainArtifact.getVersion() + "-release.zip";
        Path zipPath = this.artifactDirectory().resolve(zipName);
        try {
            Path praefix = Path.of(mainArtifact.getGroupId().replace('.', '/'), new String[0]).resolve(mainArtifact.getArtifactId()).resolve(mainArtifact.getVersion());
            throwable = null;
            Object var7_12 = null;
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));){
                for (Deployable d : toDeploy) {
                    Artifact artifact = d.artifact();
                    ZipEntry entry = new ZipEntry(praefix.resolve(artifact.getArtifactId() + "-" + artifact.getVersion() + (String)(artifact.getClassifier().isEmpty() ? "" : "-" + artifact.getClassifier()) + "." + artifact.getExtension()).toString());
                    zos.putNextEntry(entry);
                    Throwable throwable2 = null;
                    Object var14_21 = null;
                    try (InputStream fis = Files.newInputStream(artifact.getFile().toPath(), new OpenOption[0]);){
                        fis.transferTo(zos);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    zos.closeEntry();
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to create release zip: " + e.getMessage(), e);
        }
        try {
            try {
                Throwable e = null;
                throwable = null;
                try (HttpClient client = HttpClient.newHttpClient();){
                    String boundary = "===" + System.currentTimeMillis() + "===";
                    String user = Optional.ofNullable(this.repoUser).orElse(this.project().context().property("mvnrepo.user"));
                    String password = Optional.ofNullable(this.repoPass).orElse(this.project().context().property("mvnrepo.password"));
                    String token = new String(Base64.encode((user + ":" + password).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                    URI effectiveUri = this.uploadUri;
                    if (this.publishAutomatically) {
                        effectiveUri = MvnPublisher.addQueryParameter(this.uploadUri, "publishingType", "AUTOMATIC");
                    }
                    HttpRequest request = HttpRequest.newBuilder().uri(effectiveUri).header("Authorization", "Bearer " + token).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofInputStream(() -> this.getAsMultipart(zipPath, boundary))).build();
                    this.log.info(() -> "Uploading release bundle...");
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    if (response.statusCode() / 100 != 2) {
                        throw new BuildException("Failed to upload release bundle: " + response.body());
                    }
                }
                catch (Throwable throwable5) {
                    if (e == null) {
                        e = throwable5;
                    } else if (e != throwable5) {
                        e.addSuppressed(throwable5);
                    }
                    throw e;
                }
            }
            catch (IOException | InterruptedException e) {
                throw new BuildException("Failed to upload release bundle: " + e.getMessage(), e);
            }
        }
        finally {
            if (!this.keepSubArtifacts) {
                zipPath.toFile().delete();
            }
        }
    }

    private InputStream getAsMultipart(Path zipPath, String boundary) {
        PipedInputStream fromPipe = new PipedInputStream();
        String lineFeed = "\r\n";
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        executor.submit(() -> {
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedOutputStream mpOut = new BufferedOutputStream(new PipedOutputStream(fromPipe));){
                        StringBuilder intro = new StringBuilder(100).append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"bundle\";" + " filename=\"%s\"".formatted(zipPath.getFileName())).append("\r\n").append("Content-Type: application/octet-stream").append("\r\n").append("\r\n");
                        mpOut.write(intro.toString().getBytes(StandardCharsets.US_ASCII));
                        Files.newInputStream(zipPath, new OpenOption[0]).transferTo(mpOut);
                        mpOut.write(("\r\n--" + boundary + "--").getBytes(StandardCharsets.US_ASCII));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            finally {
                executor.close();
            }
        });
        return fromPipe;
    }

    private static URI addQueryParameter(URI uri, String key, String value) {
        String query = uri.getQuery();
        try {
            String newQueryParam = key + "=" + URLEncoder.encode(value, "UTF-8");
            String newQuery = query == null || query.isEmpty() ? newQueryParam : query + "&" + newQueryParam;
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), newQuery, uri.getFragment());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private record Deployable(Artifact artifact, boolean temporary) {
    }
}

