/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.mvnrepo;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.core.AbstractProvider;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.mvnrepo.MvnRepoDependency;
import org.jdrupes.builder.mvnrepo.MvnRepoJarFile;
import org.jdrupes.builder.mvnrepo.MvnRepoTypes;

public class MvnRepoLookup
extends AbstractProvider
implements ResourceProvider {
    private final List<String> coordinates = new ArrayList<String>();
    private boolean downloadSources = true;
    private boolean downloadJavadoc = true;
    private static Context rootContextInstance;

    static Context rootContext() {
        if (rootContextInstance != null) {
            return rootContextInstance;
        }
        ContextOverrides overrides = ContextOverrides.create().withUserSettings(true).build();
        Runtime runtime = Runtimes.INSTANCE.getRuntime();
        rootContextInstance = runtime.create(overrides);
        return rootContextInstance;
    }

    public MvnRepoLookup resolve(String ... coordinates) {
        this.coordinates.addAll(Arrays.asList(coordinates));
        return this;
    }

    public MvnRepoLookup downloadSources(boolean enable) {
        this.downloadSources = enable;
        return this;
    }

    public MvnRepoLookup downloadJavadoc(boolean enable) {
        this.downloadJavadoc = enable;
        return this;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (requested.wants(MvnRepoTypes.MvnRepoDependenciesType)) {
            Stream<MvnRepoDependency> result = this.coordinates.stream().map(c -> ResourceFactory.create(MvnRepoTypes.MvnRepoDependencyType, null, c));
            return result;
        }
        if (requested.wants(JavaTypes.CompilationResourcesType) && requested.includes(JavaTypes.JarFileType)) {
            return this.provideJars(requested);
        }
        return Stream.empty();
    }

    private <T extends Resource> Stream<T> provideJars(ResourceRequest<T> requested) {
        CollectRequest collectRequest = new CollectRequest().setRepositories(MvnRepoLookup.rootContext().remoteRepositories());
        for (String coord : this.coordinates) {
            collectRequest.addDependency(new Dependency(new DefaultArtifact(coord), requested.wants(JavaTypes.CompilationResourcesType) ? "compile" : "runtime"));
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        try {
            RepositorySystem repoSystem = MvnRepoLookup.rootContext().repositorySystem();
            RepositorySystemSession repoSession = MvnRepoLookup.rootContext().repositorySystemSession();
            DependencyNode rootNode = repoSystem.resolveDependencies(repoSession, dependencyRequest).getRoot();
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            rootNode.accept(nlg);
            List dependencyNodes = nlg.getNodes();
            Stream<MvnRepoJarFile> result = dependencyNodes.stream().filter(d -> d.getArtifact() != null).map(DependencyNode::getArtifact).map(a -> {
                if (this.downloadSources) {
                    this.downloadSourceJar(repoSystem, repoSession, (Artifact)a);
                }
                if (this.downloadJavadoc) {
                    this.downloadJavadocJar(repoSystem, repoSession, (Artifact)a);
                }
                return a;
            }).map(a -> a.getFile().toPath()).map(p -> ResourceFactory.create(MvnRepoTypes.MvnRepoJarFileType, p));
            return result;
        }
        catch (DependencyResolutionException e) {
            throw new BuildException("Cannot resolve: " + e.getMessage(), e);
        }
    }

    private void downloadSourceJar(RepositorySystem repoSystem, RepositorySystemSession repoSession, Artifact jarArtifact) {
        SubArtifact sourcesArtifact = new SubArtifact(jarArtifact, "sources", "jar");
        ArtifactRequest sourcesRequest = new ArtifactRequest();
        sourcesRequest.setArtifact(sourcesArtifact);
        sourcesRequest.setRepositories(MvnRepoLookup.rootContext().remoteRepositories());
        try {
            repoSystem.resolveArtifact(repoSession, sourcesRequest);
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
    }

    private void downloadJavadocJar(RepositorySystem repoSystem, RepositorySystemSession repoSession, Artifact jarArtifact) {
        SubArtifact javadocArtifact = new SubArtifact(jarArtifact, "javadoc", "jar");
        ArtifactRequest sourcesRequest = new ArtifactRequest();
        sourcesRequest.setArtifact(javadocArtifact);
        sourcesRequest.setRepositories(MvnRepoLookup.rootContext().remoteRepositories());
        try {
            repoSystem.resolveArtifact(repoSession, sourcesRequest);
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
    }
}

