/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.mvnrepo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.mvnrepo.MvnProperties;
import org.jdrupes.builder.mvnrepo.MvnRepoTypes;
import org.jdrupes.builder.mvnrepo.PomFile;

public class PomFileGenerator
extends AbstractGenerator {
    public static final String GENERATED_BY = "Generated by JDrupes Builder";
    private Supplier<Path> destination = () -> this.project().buildDirectory().resolve("publications/maven");
    private Consumer<Model> pomAdapter = model -> {};

    public PomFileGenerator(Project project) {
        super(project);
    }

    public Path destination() {
        return this.destination.get();
    }

    public PomFileGenerator destination(Path destination) {
        this.destination = () -> this.project().buildDirectory().resolve(destination);
        return this;
    }

    public PomFileGenerator destination(Supplier<Path> destination) {
        this.destination = destination;
        return this;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        Path pomPath = this.destination().resolve(String.valueOf(Optional.ofNullable(this.project().get(MvnProperties.ArtifactId)).orElse(this.project().name())) + "-pom.xml");
        if (this.cleanup(requested, pomPath)) {
            return Stream.empty();
        }
        if (!requested.includes(MvnRepoTypes.PomFileType)) {
            return Stream.empty();
        }
        pomPath.getParent().toFile().mkdirs();
        Resources deps = this.project().newResource(MvnRepoTypes.MvnRepoDependenciesType, new Object[0]).addAll(this.project().supplied(new ResourceRequest(MvnRepoTypes.MvnRepoDependenciesType)));
        Model model = this.generatePom();
        pomPath.getParent().toFile().mkdirs();
        try {
            byte[] existingContent;
            ByteArrayOutputStream newPom = new ByteArrayOutputStream();
            new DefaultModelWriter().write(newPom, null, model);
            newPom.close();
            byte[] byArray = existingContent = pomPath.toFile().exists() ? Files.readAllBytes(pomPath) : new byte[]{};
            if (Arrays.equals(newPom.toByteArray(), existingContent)) {
                this.log.fine(() -> "Existing " + String.valueOf(this.project().rootProject().directory().relativize(pomPath)) + " is up to date.");
            } else {
                this.log.fine(() -> "Updating " + String.valueOf(this.project().rootProject().directory().relativize(pomPath)) + ".");
                Files.write(pomPath, newPom.toByteArray(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        Stream<PomFile> result = Stream.of(this.project().newResource(MvnRepoTypes.PomFileType, pomPath));
        return result;
    }

    private Model generatePom() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        String groupId = (String)this.project().get(MvnProperties.GroupId);
        if (groupId != null) {
            model.setGroupId(groupId);
        }
        model.setArtifactId(Optional.ofNullable((String)this.project().get(MvnProperties.ArtifactId)).orElse(this.project().name()));
        model.setVersion((String)this.project().get(Project.Properties.Version));
        model.setName(this.project().name());
        this.pomAdapter.accept(model);
        return model;
    }

    public PomFileGenerator adaptPom(Consumer<Model> adaptor) {
        this.pomAdapter = adaptor;
        return this;
    }
}

