/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.startup;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Launcher;
import org.jdrupes.builder.api.Masked;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.RootProject;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.startup.BootstrapLauncher;

public abstract class AbstractLauncher
implements Launcher {
    protected static final Properties jdbldProps;
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected final CommandLine commandLine;

    public AbstractLauncher(String[] stringArray) {
        Options options = new Options();
        options.addOption("B-x", true, "Exclude from project scan");
        options.addOption(Option.builder("P").hasArgs().valueSeparator('=').desc("Property in form key=value").get());
        try {
            this.commandLine = new DefaultParser().parse(options, stringArray);
        }
        catch (ParseException parseException) {
            throw new BuildException(parseException);
        }
        jdbldProps.putAll((Map<?, ?>)this.commandLine.getOptionProperties("P"));
    }

    protected void findProjects(ClassLoader classLoader, List<Class<? extends RootProject>> list, List<Class<? extends Project>> list2) {
        ArrayList<URL> arrayList;
        try {
            arrayList = Collections.list(classLoader.getResources(""));
        }
        catch (IOException iOException) {
            throw new BuildException("Problem scanning classpath", iOException);
        }
        arrayList.parallelStream().filter(uRL -> !"jar".equals(uRL.getProtocol())).map(uRL -> {
            try {
                return Path.of(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new BuildException("Problem scanning classpath", uRISyntaxException);
            }
        }).map(path -> ResourceFactory.create(JavaTypes.ClassTreeType, path, "**/*.class", false)).flatMap(FileTree::entries).map(Path::toString).map(string -> string.substring(0, string.length() - 6).replace('/', '.')).map(string -> {
            try {
                return classLoader.loadClass((String)string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Cannot load detected class", classNotFoundException);
            }
        }).forEach(clazz -> {
            if (!(Masked.class.isAssignableFrom((Class<?>)clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()))) {
                if (RootProject.class.isAssignableFrom((Class<?>)clazz)) {
                    list.add((Class<? extends RootProject>)clazz);
                } else if (Project.class.isAssignableFrom((Class<?>)clazz)) {
                    list2.add((Class<? extends Project>)clazz);
                }
            }
        });
        if (list.isEmpty()) {
            throw new BuildException("No project implements RootProject");
        }
        if (list.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("More than one project implements RootProject: ").append(list.stream().map(Class::getName).collect(Collectors.joining(", ")));
            throw new BuildException(stringBuilder.toString());
        }
    }

    protected final <T> T unwrapBuildException(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception exception) {
            BuildException buildException;
            Throwable throwable = exception;
            BuildException buildException2 = null;
            for (Throwable throwable2 = exception; throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof BuildException)) continue;
                buildException2 = buildException = (BuildException)throwable2;
                throwable = buildException.getCause();
            }
            buildException = buildException2;
            if (buildException2 == null) {
                this.log.log(Level.SEVERE, exception, () -> "Starting builder failed: " + exception.getMessage());
            } else if (throwable == null) {
                this.log.severe(() -> "Build failed: " + buildException.getMessage());
            } else {
                this.log.log(Level.SEVERE, throwable, () -> "Build failed: " + buildException.getMessage());
            }
            System.exit(1);
            return null;
        }
    }

    static {
        Object object;
        Properties properties = new Properties();
        properties.putAll(Map.of("jdbldDirectory", "_jdbld"));
        for (Path object2 : List.of(Path.of(System.getProperty("user.home"), new String[0]).resolve(".jdbld").resolve("jdbld.properties"), Path.of("", new String[0]).toAbsolutePath().resolve(".jdbld.properties"))) {
            try {
                if (!object2.toFile().canRead()) continue;
                properties = new Properties(properties);
                properties.load(Files.newBufferedReader(object2));
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot read properties from " + String.valueOf(object2), iOException);
            }
        }
        jdbldProps = new Properties(properties);
        try {
            object = Files.newInputStream(Path.of(jdbldProps.getProperty("jdbldDirectory"), "logging.properties"), new OpenOption[0]);
        }
        catch (IOException iOException) {
            object = BootstrapLauncher.class.getResourceAsStream("logging.properties");
        }
        try (Object object2 = object;){
            LogManager.getLogManager().readConfiguration((InputStream)object2);
        }
        catch (IOException | SecurityException exception) {
            exception.printStackTrace();
        }
    }
}

