/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.startup;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.Masked;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.AbstractProject;
import org.jdrupes.builder.core.ResourceCollector;
import org.jdrupes.builder.java.ClasspathScanner;
import org.jdrupes.builder.java.JavaCompiler;
import org.jdrupes.builder.java.JavaResourceTree;
import org.jdrupes.builder.java.JavaSourceFile;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.startup.BootstrapRoot;

public class BootstrapBuild
extends AbstractProject
implements Masked {
    static final String BUILD_EXTENSIONS = "buildExtensions";
    protected final Logger log = Logger.getLogger(this.getClass().getName());

    public BootstrapBuild() {
        super(BootstrapBuild.parent(BootstrapRoot.class), BootstrapBuild.jdbldDirectory());
        String string = Path.of(System.getProperty("java.class.path"), new String[0]).toAbsolutePath().toString();
        this.log.fine(() -> "Using java.class.path " + string + " for builder project compilation");
        this.dependency(Intend.Consume, new ClasspathScanner(this, string));
        FileTree<FileResource> fileTree = this.newResource(new ResourceType<FileTree<FileResource>>(this){
            {
                Objects.requireNonNull(bootstrapBuild);
            }
        }, Path.of("", new String[0]).toAbsolutePath(), "**/" + this.context().jdbldDirectory().toString()).withDirectories();
        this.addExcludes(fileTree);
        Stream<FileTree<JavaSourceFile>> stream = fileTree.stream().map(fileResource -> this.newResource(JavaTypes.JavaSourceTreeType, fileResource.path().resolve("src"), "**/*.java"));
        this.generator(JavaCompiler::new).addSources(stream);
        Stream<JavaResourceTree> stream2 = fileTree.stream().map(fileResource -> this.newResource(JavaTypes.JavaResourceTreeType, fileResource.path().resolve("resources"), "**/*"));
        this.generator(new ResourceCollector<JavaResourceTree>(this, JavaTypes.JavaResourceTreeType).add(stream2));
    }

    private void addExcludes(FileTree<FileResource> fileTree) {
        for (String string : Optional.ofNullable(this.context().commandLine().getOptionValues("B-x")).orElse(new String[0])) {
            fileTree.exclude(string);
        }
    }
}

