/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.startup;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.RootProject;
import org.jdrupes.builder.core.LauncherSupport;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.startup.AbstractLauncher;

public class DirectLauncher
extends AbstractLauncher {
    private static final String RUNTIME_EXTENSIONS = "runtimeExtensions";
    private RootProject rootProject;

    public DirectLauncher(ClassLoader classLoader, String[] stringArray) {
        super(stringArray);
        this.unwrapBuildException(() -> {
            ClassLoader classLoader2 = this.addExtensions(classLoader);
            ArrayList<Class<? extends RootProject>> arrayList = new ArrayList<Class<? extends RootProject>>();
            ArrayList<Class<? extends Project>> arrayList2 = new ArrayList<Class<? extends Project>>();
            this.findProjects(classLoader2, arrayList, arrayList2);
            this.rootProject = LauncherSupport.createProjects(arrayList.get(0), arrayList2, jdbldProps, this.commandLine);
            for (String string : stringArray) {
                ResourceRequest<?>[] resourceRequestArray = LauncherSupport.lookupCommand(this.rootProject, string);
                if (resourceRequestArray.length == 0) {
                    new BuildException("Unknown command: " + string);
                }
                for (ResourceRequest<?> resourceRequest : resourceRequestArray) {
                    this.rootProject.get(resourceRequest).forEach(resource -> System.out.println(resource.toString()));
                }
            }
            return null;
        });
    }

    private ClassLoader addExtensions(ClassLoader classLoader) {
        String[] stringArray = (String[])Stream.concat(Arrays.asList(jdbldProps.getProperty("buildExtensions", "").split(",")).stream(), Arrays.asList(jdbldProps.getProperty(RUNTIME_EXTENSIONS, "").split(",")).stream()).map(String::trim).filter(string -> !string.isBlank()).toArray(String[]::new);
        if (stringArray.length == 0) {
            return classLoader;
        }
        URL[] uRLArray = (URL[])this.resolveRequested(stringArray).mapMulti((jarFile, consumer) -> {
            try {
                consumer.accept(jarFile.path().toFile().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.log.log(Level.WARNING, malformedURLException, () -> "Cannot convert " + String.valueOf(jarFile) + " to URL: " + malformedURLException.getMessage());
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(uRLArray, classLoader);
    }

    private Stream<JarFile> resolveRequested(String[] stringArray) {
        ContextOverrides contextOverrides = ContextOverrides.create().withUserSettings(true).build();
        Runtime runtime = Runtimes.INSTANCE.getRuntime();
        try (Context context = runtime.create(contextOverrides);){
            CollectRequest collectRequest = new CollectRequest().setRepositories(context.remoteRepositories());
            for (String string : stringArray) {
                collectRequest.addDependency(new Dependency(new DefaultArtifact(string), "runtime"));
            }
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            try {
                DependencyNode dependencyNode2 = context.repositorySystem().resolveDependencies(context.repositorySystemSession(), dependencyRequest).getRoot();
                PreorderNodeListGenerator dependencyResolutionException = new PreorderNodeListGenerator();
                dependencyNode2.accept(dependencyResolutionException);
                List list = dependencyResolutionException.getNodes();
                Stream<JarFile> stream = list.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).map(dependencyNode -> dependencyNode.getArtifact().getFile().toPath()).map(path -> ResourceFactory.create(JavaTypes.JarFileType, path));
                return stream;
            }
            catch (DependencyResolutionException dependencyResolutionException) {
                throw new BuildException("Cannot resolve: " + dependencyResolutionException.getMessage(), dependencyResolutionException);
            }
        }
    }

    @Override
    public <T extends Resource> Stream<T> provide(ResourceRequest<T> resourceRequest) {
        return this.unwrapBuildException(() -> {
            List list = this.rootProject.get(resourceRequest).toList();
            return list.stream();
        });
    }

    public static void main(String[] stringArray) {
        new DirectLauncher(Thread.currentThread().getContextClassLoader(), stringArray);
    }
}

