/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.uberjar;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.IOResource;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JarFileEntry;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.java.LibraryGenerator;
import org.jdrupes.builder.java.LibraryJarFile;
import org.jdrupes.builder.java.RuntimeResources;
import org.jdrupes.builder.java.ServicesEntryResource;
import org.jdrupes.builder.mvnrepo.MvnRepoJarFile;
import org.jdrupes.builder.mvnrepo.MvnRepoLookup;
import org.jdrupes.builder.mvnrepo.MvnRepoTypes;

public class UberJarGenerator
extends LibraryGenerator {
    private Map<Path, java.util.jar.JarFile> openJars = Map.of();

    public UberJarGenerator(Project project) {
        super(project);
    }

    @Override
    protected void collectFromProviders(Map<Path, Resources<IOResource>> map) {
        this.openJars = new ConcurrentHashMap<Path, java.util.jar.JarFile>();
        ((Stream)this.project().getFrom(this.providers().stream(), new ResourceRequest(new ResourceType<RuntimeResources>(this){
            {
                Objects.requireNonNull(uberJarGenerator);
            }
        })).parallel()).forEach(classpathElement -> {
            JarFile jarFile;
            if (classpathElement instanceof FileTree) {
                FileTree fileTree = (FileTree)((Object)classpathElement);
                this.collect(map, fileTree);
            } else if (classpathElement instanceof JarFile && !((jarFile = (JarFile)classpathElement) instanceof MvnRepoJarFile)) {
                this.addJarFile(map, jarFile, this.openJars);
            }
        });
        MvnRepoLookup mvnRepoLookup = new MvnRepoLookup();
        this.project().getFrom(this.providers().stream(), new ResourceRequest(MvnRepoTypes.MvnRepoDependenciesType)).forEach(mvnRepoDependency -> mvnRepoLookup.resolve(mvnRepoDependency.coordinates()));
        ((Stream)this.project().context().get(mvnRepoLookup, new ResourceRequest(new ResourceType<RuntimeResources>(this){
            {
                Objects.requireNonNull(uberJarGenerator);
            }
        })).parallel()).forEach(classpathElement -> {
            if (classpathElement instanceof MvnRepoJarFile) {
                MvnRepoJarFile mvnRepoJarFile = (MvnRepoJarFile)classpathElement;
                this.addJarFile(map, mvnRepoJarFile, this.openJars);
            }
        });
    }

    private void addJarFile(Map<Path, Resources<IOResource>> map, JarFile jarFile, Map<Path, java.util.jar.JarFile> map2) {
        java.util.jar.JarFile jarFile2 = map2.computeIfAbsent(jarFile.path(), path -> {
            try {
                return new java.util.jar.JarFile(jarFile.path().toFile());
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot open resource " + String.valueOf(jarFile) + ": " + iOException.getMessage());
            }
        });
        jarFile2.stream().filter(Predicate.not(ZipEntry::isDirectory)).filter(jarEntry -> !Path.of(jarEntry.getName(), new String[0]).endsWith(Path.of("module-info.class", new String[0]))).filter(jarEntry -> {
            Iterator<Path> iterator = Path.of(jarEntry.getRealName(), new String[0]).iterator();
            if (iterator.next().equals(Path.of("META-INF", new String[0]))) {
                iterator.next();
                return iterator.hasNext();
            }
            return true;
        }).forEach(jarEntry -> {
            Path path2 = Path.of(jarEntry.getRealName(), new String[0]);
            map.computeIfAbsent(path2, path -> this.project().newResource(ResourceType.IOResourcesType, new Object[0])).add(new JarFileEntry(jarFile2, (JarEntry)jarEntry));
        });
    }

    @Override
    protected void resolveDuplicates(Map<Path, Resources<IOResource>> map) {
        map.entrySet().parallelStream().forEach(entry -> {
            Resources resources = (Resources)entry.getValue();
            if (resources.stream().count() == 1L) {
                return;
            }
            Path path = (Path)entry.getKey();
            if (path.startsWith("META-INF/services")) {
                ServicesEntryResource servicesEntryResource = new ServicesEntryResource();
                resources.stream().forEach(iOResource -> {
                    try {
                        servicesEntryResource.add((IOResource)iOResource);
                    }
                    catch (IOException iOException) {
                        throw new BuildException("Cannot read " + String.valueOf(iOResource));
                    }
                });
                resources.clear();
                resources.add(servicesEntryResource);
                return;
            }
            if (path.startsWith("META-INF")) {
                resources.clear();
            }
            resources.stream().reduce((iOResource, iOResource2) -> {
                this.log.warning(() -> "Entry " + String.valueOf(path) + " from " + String.valueOf(iOResource) + " duplicates entry from " + String.valueOf(iOResource2) + " and is skipped.");
                return iOResource;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> resourceRequest) {
        LibraryJarFile libraryJarFile;
        if (!resourceRequest.includes(JavaTypes.AppJarFileType) && !resourceRequest.includes(ResourceType.CleanlinessType)) {
            return Stream.empty();
        }
        if (JavaTypes.AppJarFileType.isAssignableFrom(resourceRequest.type().containedType()) && this.mainClass() == null) {
            throw new BuildException("Main class must be set for " + this.name() + " in " + String.valueOf(this.project()));
        }
        Path path = this.destination();
        if (!path.toFile().exists() && !path.toFile().mkdirs()) {
            throw new BuildException("Cannot create directory " + String.valueOf(path));
        }
        LibraryJarFile libraryJarFile2 = libraryJarFile = JavaTypes.AppJarFileType.isAssignableFrom(resourceRequest.type().containedType()) ? (LibraryJarFile)this.project().newResource(JavaTypes.AppJarFileType, path.resolve(this.jarName())) : this.project().newResource(JavaTypes.LibraryJarFileType, path.resolve(this.jarName()));
        if (resourceRequest.includes(ResourceType.CleanlinessType)) {
            libraryJarFile.delete();
            return Stream.empty();
        }
        try {
            this.buildJar(libraryJarFile);
        }
        finally {
            for (java.util.jar.JarFile jarFile : this.openJars.values()) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Stream.of(libraryJarFile);
    }
}

