/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.vscode;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.AbstractGenerator;
import org.jdrupes.builder.java.JarFile;
import org.jdrupes.builder.java.JavaCompiler;
import org.jdrupes.builder.java.JavaTypes;
import org.jdrupes.builder.vscode.VscodeConfiguration;

public class VscodeConfigurator
extends AbstractGenerator {
    private final Map<String, Path> jdkLocations = new HashMap<String, Path>();
    private Consumer<Map<String, Object>> settingsAdaptor = map -> {};
    private Consumer<Map<String, Object>> launchAdaptor = map -> {};
    private Consumer<Map<String, Object>> tasksAdaptor = map -> {};
    private Runnable configurationAdaptor = () -> {};

    public VscodeConfigurator(Project project) {
        super(project);
    }

    public VscodeConfigurator adaptSettings(Consumer<Map<String, Object>> adaptor) {
        this.settingsAdaptor = adaptor;
        return this;
    }

    public VscodeConfigurator jdk(String version, Path location) {
        this.jdkLocations.put(version, location);
        return this;
    }

    @Override
    protected <T extends Resource> Stream<T> doProvide(ResourceRequest<T> requested) {
        if (!requested.includes(ResourceType.resourceType(VscodeConfiguration.class))) {
            return Stream.empty();
        }
        Path vscodeDir = this.project().directory().resolve(".vscode");
        vscodeDir.toFile().mkdirs();
        try {
            this.generateSettingsJson(vscodeDir.resolve("settings.json"));
            this.generateLaunchJson(vscodeDir.resolve("launch.json"));
            this.generateTasksJson(vscodeDir.resolve("tasks.json"));
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        this.configurationAdaptor.run();
        Stream<VscodeConfiguration> result = Stream.of(this.project().newResource(ResourceType.resourceType(VscodeConfiguration.class), this.project().directory()));
        return result;
    }

    private void generateSettingsJson(Path file) throws IOException {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("java.configuration.updateBuildConfiguration", "automatic");
        this.project().providers(Intend.Supply, new Intend[0]).filter(p -> p instanceof JavaCompiler).map(p -> (JavaCompiler)p).findFirst().flatMap(jc -> jc.optionArgument("--release", "--target", "-target")).filter(this.jdkLocations::containsKey).ifPresent(version -> {
            HashMap<String, Object> runtime = new HashMap<String, Object>();
            runtime.put("name", "JavaSE-" + version);
            runtime.put("path", this.jdkLocations.get(version).toString());
            runtime.put("default", true);
            settings.put("java.configuration.runtimes", List.of(runtime));
        });
        ArrayList referenced = new ArrayList();
        this.collectContributing(this.project()).collect(Collectors.toSet()).stream().forEach(proj -> referenced.add(proj.buildDirectory().resolve("classes").toString()));
        referenced.addAll(this.project().provided(new ResourceRequest(JavaTypes.CompilationResourcesType)).filter(p -> p instanceof JarFile).map(jf -> ((JarFile)jf).path().toString()).collect(Collectors.toList()));
        if (!referenced.isEmpty()) {
            settings.put("java.project.referencedLibraries", referenced);
        }
        this.settingsAdaptor.accept(settings);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(settings);
        Files.writeString(file, (CharSequence)json, new OpenOption[0]);
    }

    private Stream<Project> collectContributing(Project project) {
        return project.providers(Intend.Consume, Intend.Forward, Intend.Expose).filter(p -> p instanceof Project).map(p -> (Project)p).map(p -> Stream.concat(Stream.of(p), this.collectContributing((Project)p))).flatMap(s -> s);
    }

    private void generateLaunchJson(Path file) throws IOException {
        HashMap<String, Object> launch = new HashMap<String, Object>();
        launch.put("version", "0.2.0");
        launch.put("configurations", new ArrayList());
        this.launchAdaptor.accept(launch);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(launch);
        Files.writeString(file, (CharSequence)json, new OpenOption[0]);
    }

    public VscodeConfigurator adaptLaunch(Consumer<Map<String, Object>> adaptor) {
        this.launchAdaptor = adaptor;
        return this;
    }

    private void generateTasksJson(Path file) throws IOException {
        HashMap<String, Object> tasks = new HashMap<String, Object>();
        tasks.put("version", "2.0.0");
        tasks.put("tasks", new ArrayList());
        this.tasksAdaptor.accept(tasks);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(tasks);
        Files.writeString(file, (CharSequence)json, new OpenOption[0]);
    }

    public VscodeConfigurator adaptTasks(Consumer<Map<String, Object>> adaptor) {
        this.tasksAdaptor = adaptor;
        return this;
    }

    public VscodeConfigurator adaptConfiguration(Runnable adaptor) {
        this.configurationAdaptor = adaptor;
        return this;
    }
}

