/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.mdoclet.renderers;

import com.sun.javadoc.SeeTag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdrupes.mdoclet.MDoclet;
import org.jdrupes.mdoclet.renderers.TagRenderer;
import org.jdrupes.mdoclet.renderers.TagRendering;

public class SeeTagRenderer
implements TagRenderer<SeeTag> {
    public static final SeeTagRenderer INSTANCE = new SeeTagRenderer();
    private static final Pattern SIMPLE_LINK = Pattern.compile("(?<label>[^<]*)<(?<url>[^>]+)>");

    @Override
    public void render(SeeTag tag, StringBuilder target, MDoclet doclet) {
        if (tag.text().startsWith("\"") && tag.text().endsWith("\"") && tag.text().length() > 1) {
            String text = tag.text().substring(1, tag.text().length() - 1).trim();
            Matcher matcher = SIMPLE_LINK.matcher(text);
            if (matcher.matches()) {
                String label = matcher.group("label");
                label = label == null || label.isEmpty() ? matcher.group("url") : label.trim();
                text = "[" + label + "](" + matcher.group("url") + ")";
            }
            target.append(tag.name()).append(" ").append(TagRendering.simplifySingleParagraph(doclet.toHtml(text)));
            return;
        }
        VERBATIM.render(tag, target, doclet);
    }
}

