/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.mdoclet;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdrupes.mdoclet.MarkdownProcessor;
import org.jdrupes.mdoclet.Options;
import org.jdrupes.mdoclet.RootDocWrapper;
import org.jdrupes.mdoclet.Tags;
import org.jdrupes.mdoclet.renderers.ParamTagRenderer;
import org.jdrupes.mdoclet.renderers.SeeTagRenderer;
import org.jdrupes.mdoclet.renderers.SimpleTagRenderer;
import org.jdrupes.mdoclet.renderers.TagRenderer;
import org.jdrupes.mdoclet.renderers.ThrowsTagRenderer;

public class MDoclet
extends Doclet
implements DocErrorReporter {
    public static final String HIGHLIGHT_JS_HTML = "<script type=\"text/javascript\" charset=\"utf-8\" src=\"{@docRoot}/highlight.pack.js\"></script>\n<script type=\"text/javascript\"><!--\nvar cssId = 'highlightCss';\nif (!document.getElementById(cssId))\n{\n    var head  = document.getElementsByTagName('head')[0];\n    var link  = document.createElement('link');\n    link.id   = cssId;\n    link.rel  = 'stylesheet';\n    link.type = 'text/css';\n    link.charset = 'utf-8';\n    link.href = '{@docRoot}/highlight.css';\n    link.media = 'all';\n    head.appendChild(link);\n}hljs.initHighlightingOnLoad();\n//--></script>";
    private static final Pattern LINE_START = Pattern.compile("^ ", 8);
    private final Map<String, TagRenderer<?>> tagRenderers = new HashMap();
    private final Set<PackageDoc> packages = new HashSet<PackageDoc>();
    private final Options options;
    private final RootDoc rootDoc;
    private MarkdownProcessor processor = null;
    private boolean error = false;

    public MDoclet(Options options, RootDoc rootDoc) {
        this.options = options;
        this.rootDoc = rootDoc;
        this.tagRenderers.put("@author", SimpleTagRenderer.INSTANCE);
        this.tagRenderers.put("@version", SimpleTagRenderer.INSTANCE);
        this.tagRenderers.put("@return", SimpleTagRenderer.INSTANCE);
        this.tagRenderers.put("@deprecated", SimpleTagRenderer.INSTANCE);
        this.tagRenderers.put("@since", SimpleTagRenderer.INSTANCE);
        this.tagRenderers.put("@param", ParamTagRenderer.INSTANCE);
        this.tagRenderers.put("@throws", ThrowsTagRenderer.INSTANCE);
        this.tagRenderers.put("@see", SeeTagRenderer.INSTANCE);
        for (String tag : options.getMarkedDownTags()) {
            this.tagRenderers.put("@" + tag, SimpleTagRenderer.INSTANCE);
        }
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        return Options.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter errorReporter) {
        return Options.validOptions(options, errorReporter);
    }

    public static boolean start(RootDoc rootDoc) {
        Options options = new Options();
        String[][] forwardedOptions = options.load(rootDoc.options(), (DocErrorReporter)rootDoc);
        if (forwardedOptions == null) {
            return false;
        }
        MDoclet doclet = new MDoclet(options, rootDoc);
        doclet.process();
        if (doclet.isError()) {
            return false;
        }
        RootDocWrapper rootDocWrapper = new RootDocWrapper(rootDoc, forwardedOptions);
        if (options.isHighlightEnabled()) {
            int i;
            for (i = 0; i < rootDocWrapper.options().length; ++i) {
                if (!rootDocWrapper.options()[i][0].equals("-footer")) continue;
                String[] stringArray = rootDocWrapper.options()[i];
                stringArray[1] = stringArray[1] + HIGHLIGHT_JS_HTML;
                break;
            }
            if (i >= rootDocWrapper.options().length) {
                rootDocWrapper.appendOption("-footer", HIGHLIGHT_JS_HTML);
            }
            if (Standard.optionLength((String)"--allow-script-in-comments") == 1 && rootDocWrapper.findOption("--allow-script-in-comments") == null) {
                rootDocWrapper.appendOption("--allow-script-in-comments");
            }
        }
        return Standard.start((RootDoc)rootDocWrapper) && doclet.postProcess();
    }

    public void clearTagRenderers() {
        this.tagRenderers.clear();
    }

    public void addTagRenderer(String kind, TagRenderer<?> renderer) {
        this.tagRenderers.put(kind, renderer);
    }

    public void removeTagRenderer(String kind) {
        this.tagRenderers.remove(kind);
    }

    public Options getOptions() {
        return this.options;
    }

    public RootDoc getRootDoc() {
        return this.rootDoc;
    }

    public void process() {
        this.processor = this.options.getProcessor();
        try {
            this.processor.start(this.options.getProcessorOptions());
        }
        catch (Throwable e) {
            this.printError(e.getMessage());
            return;
        }
        this.processOverview();
        for (ClassDoc doc : this.rootDoc.classes()) {
            this.packages.add(doc.containingPackage());
            this.processClass(doc);
        }
        for (PackageDoc doc : this.packages) {
            this.processPackage(doc);
        }
    }

    public boolean postProcess() {
        boolean success = true;
        if (this.options.isHighlightEnabled()) {
            success &= this.copyResource("highlight.pack.js", "highlight.pack.js", "highlight.js");
            success &= this.copyResource("highlight-LICENSE.txt", "highlight-LICENSE.txt", "highlight.js license");
            success &= this.copyResource("highlight-styles/" + this.options.getHighlightStyle() + ".css", "highlight.css", "highlight.js style '" + this.options.getHighlightStyle() + "'");
        }
        return success;
    }

    /*
     * Exception decompiling
     */
    private boolean copyResource(String resource, String destination, String description) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isError() {
        return this.error;
    }

    protected void processOverview() {
        if (this.options.getOverviewFile() != null) {
            try {
                this.rootDoc.setRawCommentText(new String(Files.readAllBytes(this.options.getOverviewFile().toPath()), this.options.getEncoding()));
                this.defaultProcess((Doc)this.rootDoc, false);
            }
            catch (IOException e) {
                this.printError("Error loading overview from " + this.options.getOverviewFile() + ": " + e.getLocalizedMessage());
                this.rootDoc.setRawCommentText("");
            }
        }
    }

    protected void processClass(ClassDoc doc) {
        this.defaultProcess((Doc)doc, true);
        for (FieldDoc fieldDoc : doc.fields()) {
            this.processMember((MemberDoc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.constructors()) {
            this.processMember((MemberDoc)fieldDoc);
        }
        for (FieldDoc fieldDoc : doc.methods()) {
            this.processMember((MemberDoc)fieldDoc);
        }
        if (doc instanceof AnnotationTypeDoc) {
            for (FieldDoc fieldDoc : ((AnnotationTypeDoc)doc).elements()) {
                this.processMember((MemberDoc)fieldDoc);
            }
        }
    }

    protected void processMember(MemberDoc doc) {
        this.defaultProcess((Doc)doc, true);
    }

    protected void processPackage(PackageDoc doc) {
        try {
            Field foundDoc = doc.getClass().getDeclaredField("foundDoc");
            foundDoc.setAccessible(true);
            foundDoc.set(doc, false);
        }
        catch (Exception e) {
            this.printWarning(doc.position(), "Cannot suppress warning about multiple package sources: " + e);
        }
        this.defaultProcess((Doc)doc, true);
    }

    protected void defaultProcess(Doc doc, boolean fixLeadingSpaces) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(this.toHtml(doc.commentText(), fixLeadingSpaces));
            buf.append('\n');
            for (Tag tag : doc.tags()) {
                this.processTag(tag, buf);
                buf.append('\n');
            }
            doc.setRawCommentText(buf.toString());
        }
        catch (Throwable e) {
            if (doc instanceof RootDoc) {
                this.printError(new SourcePosition(){

                    public File file() {
                        return MDoclet.this.options.getOverviewFile();
                    }

                    public int line() {
                        return 0;
                    }

                    public int column() {
                        return 0;
                    }
                }, e.getMessage());
            }
            this.printError(doc.position(), e.getMessage());
        }
    }

    protected void processTag(Tag tag, StringBuilder target) {
        TagRenderer<Object> renderer = this.tagRenderers.get(tag.kind());
        if (renderer == null) {
            renderer = TagRenderer.VERBATIM;
        }
        renderer.render(tag, target, this);
    }

    public void clearProcessor() {
        this.processor = null;
    }

    public String toHtml(String markup) {
        return this.toHtml(markup, true);
    }

    public String toHtml(String markup, boolean fixLeadingSpaces) {
        if (fixLeadingSpaces) {
            markup = LINE_START.matcher(markup).replaceAll("");
        }
        ArrayList<String> tags = new ArrayList<String>();
        String html = this.processor.toHtml(Tags.extractInlineTags(markup, tags));
        return Tags.insertInlineTags(html, tags);
    }

    public void error() {
        this.error = true;
    }

    public void printError(String msg) {
        this.error();
        this.rootDoc.printError(msg);
    }

    public void printError(SourcePosition pos, String msg) {
        this.error();
        this.rootDoc.printError(pos, msg);
    }

    public void printWarning(String msg) {
        this.rootDoc.printWarning(msg);
    }

    public void printWarning(SourcePosition pos, String msg) {
        this.rootDoc.printWarning(pos, msg);
    }

    public void printNotice(String msg) {
        this.rootDoc.printNotice(msg);
    }

    public void printNotice(SourcePosition pos, String msg) {
        this.rootDoc.printNotice(pos, msg);
    }

    public String rootUrlPrefix(PackageDoc doc) {
        if (doc == null || doc.name().isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("../");
        for (int i = 0; i < doc.name().length(); ++i) {
            if (doc.name().charAt(i) != '.') continue;
            buf.append("../");
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        args = Arrays.copyOf(args, args.length + 2);
        args[args.length - 2] = "-doclet";
        args[args.length - 1] = MDoclet.class.getName();
        Main.main((String[])args);
    }
}

