/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.mdoclet.processors;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.jdrupes.mdoclet.MarkdownProcessor;

public class FlexmarkProcessor
implements MarkdownProcessor {
    private static final String OPT_PROFILE = "-parser-profile";
    private static final String OPT_CLEAR_EXTENSIONS = "-clear-extensions";
    private static final String OPT_EXTENSION = "-extension";
    private Parser parser;
    private HtmlRenderer renderer;

    @Override
    public int isSupportedOption(String option) {
        switch (option) {
            case "-clear-extensions": 
            case "_disable-auto-highlight_": {
                return 0;
            }
            case "-parser-profile": 
            case "-extension": {
                return 1;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(String[][] options) {
        void var6_8;
        MutableDataSet flexmarkOpts = new MutableDataSet();
        HashSet extensions = new HashSet();
        extensions.add(AbbreviationExtension.class);
        extensions.add(DefinitionExtension.class);
        extensions.add(FootnoteExtension.class);
        extensions.add(TablesExtension.class);
        extensions.add(TypographicExtension.class);
        extensions.add(WikiLinkExtension.class);
        String[][] stringArray = options;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            String[] opt = stringArray[var6_8];
            switch (opt[0]) {
                case "-parser-profile": {
                    this.setFromProfile(flexmarkOpts, opt[1]);
                    break;
                }
                case "-clear-extensions": {
                    extensions.clear();
                    break;
                }
                case "-extension": {
                    try {
                        String clsName = opt[1];
                        if (!clsName.contains(".")) {
                            clsName = "com.vladsch.flexmark.ext." + opt[1].toLowerCase() + "." + opt[1] + "Extension";
                        }
                        Class<?> cls = this.getClass().getClassLoader().loadClass(clsName);
                        extensions.add(cls);
                        break;
                    }
                    catch (ClassCastException | ClassNotFoundException e) {
                        throw new IllegalArgumentException("Cannot find extension " + opt[1] + " (check spelling and classpath).");
                    }
                }
                case "_disable-auto-highlight_": {
                    flexmarkOpts.set(HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS, (Object)"nohighlight");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option: " + opt[0]);
                }
            }
            ++var6_8;
        }
        ArrayList<Extension> extObjs = new ArrayList<Extension>();
        for (Class clazz : extensions) {
            try {
                extObjs.add((Extension)clazz.getMethod("create", new Class[0]).invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create extension of type " + clazz + ".");
            }
        }
        if (!extObjs.isEmpty()) {
            flexmarkOpts.set(Parser.EXTENSIONS, extObjs);
        }
        this.parser = Parser.builder((DataHolder)flexmarkOpts).build();
        this.renderer = HtmlRenderer.builder((DataHolder)flexmarkOpts).build();
    }

    private void setFromProfile(MutableDataSet fmOpts, String profileName) {
        for (ParserEmulationProfile p : ParserEmulationProfile.values()) {
            if (!p.toString().equalsIgnoreCase(profileName)) continue;
            fmOpts.setFrom((MutableDataSetter)p);
            return;
        }
        throw new IllegalArgumentException("Unknown profile: " + profileName);
    }

    @Override
    public String toHtml(String markdown) {
        Node document = this.parser.parse(markdown);
        return this.renderer.render(document);
    }
}

