/*
 * Decompiled with CFR 0.152.
 */
package org.jdto.mergers;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.Serializable;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jdto.mergers.GroovyMerger;
import org.jdto.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroovyMerger
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOGGER_VARIABLE_NAME = "logger";
    protected static final CompilerConfiguration currentConfiguration = new CompilerConfiguration();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Object evaluateGroovyScript(Binding binding, String expression) {
        binding.setVariable(LOGGER_VARIABLE_NAME, (Object)this.logger);
        GroovyShell shell = new GroovyShell(binding, GroovyMerger.currentConfiguration);
        return shell.evaluate(expression);
    }

    protected String getExpression(String[] extraParam) {
        if (ArrayUtils.isEmpty((Object[])extraParam) || StringUtils.isEmpty((String)extraParam[0])) {
            this.logger.error("You should provide a groovy script expression to evaluate.");
            throw new IllegalArgumentException("Invalid Groovy expression");
        }
        String expression = extraParam[0];
        return expression;
    }

    public boolean isRestoreSupported(String[] params) {
        return false;
    }

    public Object restoreObject(Object object, String[] params) {
        return null;
    }

    private static ImportCustomizer performImports() {
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{"org.apache.commons.lang", "java.util", "java.math"});
        return ic;
    }

    static {
        currentConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{AbstractGroovyMerger.performImports()});
    }
}

