/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.msexcel;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Header;

public class MsExcelRecord
extends GenericRecord<Row> {
    public MsExcelRecord(Header header, Row payload) {
        super(header, (Object)payload);
    }

    public String toString() {
        return "Record: {header=" + this.header + ", payload=" + this.dump((Row)this.payload) + '}';
    }

    private String dump(Row row) {
        StringBuilder stringBuilder = new StringBuilder();
        int lastCellNum = row.getLastCellNum();
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            stringBuilder.append("\"");
            switch (cell.getCellType()) {
                case 4: {
                    stringBuilder.append(cell.getBooleanCellValue());
                    break;
                }
                case 0: {
                    stringBuilder.append(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    stringBuilder.append(cell.getStringCellValue());
                    break;
                }
            }
            stringBuilder.append("\"");
            if (i >= lastCellNum - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }
}

