/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.msexcel;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.jeasy.batch.core.mapper.ObjectMapper;
import org.jeasy.batch.core.mapper.RecordMapper;
import org.jeasy.batch.core.record.GenericRecord;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.extensions.msexcel.MsExcelRecord;

public class MsExcelRecordMapper<P>
implements RecordMapper<MsExcelRecord, Record<P>> {
    private String[] fields;
    private ObjectMapper<P> objectMapper;

    public MsExcelRecordMapper(Class<P> type, String ... fields) {
        this.fields = fields;
        this.objectMapper = new ObjectMapper(type);
    }

    public Record<P> processRecord(MsExcelRecord msExcelRecord) throws Exception {
        Object unmarshalledObject = this.objectMapper.mapObject(this.toMap((Row)msExcelRecord.getPayload()));
        return new GenericRecord(msExcelRecord.getHeader(), unmarshalledObject);
    }

    private Map<String, String> toMap(Row row) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.fields.length; ++i) {
            Cell cell = row.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            map.put(this.fields[i], this.getCellValue(cell));
        }
        return map;
    }

    private String getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 0: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case 1: {
                return cell.getStringCellValue();
            }
        }
        return "";
    }
}

