/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.msexcel;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.jeasy.batch.core.field.BeanFieldExtractor;
import org.jeasy.batch.core.field.FieldExtractor;
import org.jeasy.batch.core.marshaller.RecordMarshaller;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.util.Utils;
import org.jeasy.batch.extensions.msexcel.MsExcelRecord;
import org.jeasy.batch.extensions.msexcel.MsExcelRow;

public class MsExcelRecordMarshaller<P>
implements RecordMarshaller<Record<P>, MsExcelRecord> {
    private FieldExtractor<P> fieldExtractor;

    public MsExcelRecordMarshaller(Class<P> type, String ... fields) {
        this((FieldExtractor<P>)new BeanFieldExtractor(type, fields));
    }

    public MsExcelRecordMarshaller(FieldExtractor<P> fieldExtractor) {
        Utils.checkNotNull(fieldExtractor, (String)"field extractor");
        this.fieldExtractor = fieldExtractor;
    }

    public MsExcelRecord processRecord(Record<P> record) throws Exception {
        MsExcelRow row = new MsExcelRow();
        Iterable values = this.fieldExtractor.extractFields(record.getPayload());
        int i = 0;
        for (Object value : values) {
            Cell cell = row.createCell(i++);
            this.setValue(cell, value);
        }
        return new MsExcelRecord(record.getHeader(), row);
    }

    private void setValue(Cell cell, Object value) {
        if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
            cell.setCellType(4);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            cell.setCellValue(Double.parseDouble(value.toString()));
            cell.setCellType(0);
        }
        if (value instanceof String) {
            cell.setCellValue((String)value);
            cell.setCellType(1);
        }
        if (value instanceof Date) {
            cell.setCellValue((Date)value);
            cell.setCellType(1);
        }
        if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
            cell.setCellType(1);
        }
    }
}

