/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.msexcel;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeasy.batch.core.reader.RecordReader;
import org.jeasy.batch.core.record.Header;
import org.jeasy.batch.extensions.msexcel.MsExcelRecord;

public class MsExcelRecordReader
implements RecordReader {
    private Path path;
    private XSSFSheet sheet;
    private XSSFWorkbook workbook;
    private Iterator<Row> rowIterator;
    private long recordNumber;

    public MsExcelRecordReader(Path path) throws IOException {
        this(path, 0);
    }

    public MsExcelRecordReader(Path path, int sheetIndex) throws IOException {
        this.path = path;
        try {
            this.workbook = new XSSFWorkbook(path.toFile());
            this.sheet = this.workbook.getSheetAt(sheetIndex);
        }
        catch (InvalidFormatException e) {
            throw new IOException("Invalid MsExcel file format. Only 'xlsx' is supported", e);
        }
    }

    public void open() {
        this.recordNumber = 1L;
        this.rowIterator = this.sheet.iterator();
    }

    public MsExcelRecord readRecord() {
        if (this.rowIterator.hasNext()) {
            Header header = new Header(Long.valueOf(this.recordNumber++), this.getDataSourceName(), LocalDateTime.now());
            Row payload = this.rowIterator.next();
            return new MsExcelRecord(header, payload);
        }
        return null;
    }

    private String getDataSourceName() {
        return String.format("Sheet '%s' in file %s", this.sheet.getSheetName(), this.path.toAbsolutePath().toString());
    }

    public void close() throws Exception {
        this.workbook.close();
    }
}

