/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.batch.extensions.msexcel;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeasy.batch.core.record.Batch;
import org.jeasy.batch.core.record.Record;
import org.jeasy.batch.core.writer.RecordWriter;

public class MsExcelRecordWriter
implements RecordWriter {
    private Path path;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;

    public MsExcelRecordWriter(Path path, String sheetName) {
        this.path = path;
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet(sheetName);
    }

    private void setValue(XSSFCell cell, Cell next) {
        switch (next.getCellType()) {
            case 4: {
                cell.setCellValue(next.getBooleanCellValue());
                cell.setCellType(4);
                break;
            }
            case 0: {
                cell.setCellValue(next.getNumericCellValue());
                cell.setCellType(0);
                break;
            }
            case 1: {
                cell.setCellValue(next.getStringCellValue());
                cell.setCellType(1);
                break;
            }
            case 2: {
                cell.setCellValue(next.getCellFormula());
                cell.setCellType(2);
            }
        }
    }

    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            XSSFRow row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            int i = 0;
            int lastCellNum = ((Row)record.getPayload()).getLastCellNum();
            for (int index = 0; index < lastCellNum; ++index) {
                Cell nextCell = ((Row)record.getPayload()).getCell(index);
                XSSFCell cell = row.createCell(i++);
                this.setValue(cell, nextCell);
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.path.toFile());
        this.workbook.write((OutputStream)fileOutputStream);
    }

    public void close() throws Exception {
        this.workbook.close();
    }
}

