/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jeasy.props.DaemonThreadFactory;
import org.jeasy.props.PropertiesInjectionTask;
import org.jeasy.props.annotations.HotReload;
import org.jeasy.props.api.PropertiesInjector;

class HotReloadingRegistrar {
    private final Map<Object, Runnable> hotReloadingTasks = new HashMap<Object, Runnable>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.newDaemonThreadFactory());

    HotReloadingRegistrar() {
    }

    void registerHotReloadingTask(PropertiesInjector propertiesInjector, Object target) {
        if (this.shouldBeHotReloaded(target)) {
            HotReload hotReload = target.getClass().getAnnotation(HotReload.class);
            long period = hotReload.period();
            TimeUnit unit = hotReload.unit();
            PropertiesInjectionTask propertiesInjectionTask = new PropertiesInjectionTask(propertiesInjector, target);
            this.scheduledExecutorService.scheduleAtFixedRate(propertiesInjectionTask, 0L, period, unit);
            this.hotReloadingTasks.put(target, propertiesInjectionTask);
        }
    }

    private boolean shouldBeHotReloaded(Object target) {
        return target.getClass().isAnnotationPresent(HotReload.class) && !this.hotReloadingTasks.containsKey(target);
    }
}

