/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jeasy.props.PropertiesInjectorImpl;
import org.jeasy.props.api.AnnotationProcessor;
import org.jeasy.props.api.PropertiesInjector;
import org.jeasy.props.converters.TypeConverter;

public class PropertiesInjectorBuilder {
    private static final Logger LOGGER = Logger.getLogger(PropertiesInjectorBuilder.class.getName());
    private PropertiesInjectorImpl propertiesInjector = new PropertiesInjectorImpl();

    public static PropertiesInjectorBuilder aNewPropertiesInjectorBuilder() {
        return new PropertiesInjectorBuilder();
    }

    public static PropertiesInjector aNewPropertiesInjector() {
        return new PropertiesInjectorBuilder().build();
    }

    public PropertiesInjectorBuilder registerAnnotationProcessor(Class<? extends Annotation> annotation, AnnotationProcessor annotationProcessor) {
        this.propertiesInjector.registerAnnotationProcessor(annotation, annotationProcessor);
        return this;
    }

    public PropertiesInjectorBuilder registerTypeConverter(Class<?> targetType, TypeConverter converter) {
        this.propertiesInjector.registerTypeConverter(targetType, converter);
        return this;
    }

    public PropertiesInjector build() {
        return this.propertiesInjector;
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(PropertiesInjectorBuilder.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load log configuration file", e);
        }
    }
}

