/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.jeasy.props.annotations.DBProperty;
import org.jeasy.props.annotations.EnvironmentVariable;
import org.jeasy.props.annotations.I18NProperty;
import org.jeasy.props.annotations.JNDIProperty;
import org.jeasy.props.annotations.ManifestProperty;
import org.jeasy.props.annotations.MavenProperty;
import org.jeasy.props.annotations.Properties;
import org.jeasy.props.annotations.Property;
import org.jeasy.props.annotations.SystemProperty;
import org.jeasy.props.api.AnnotationProcessor;
import org.jeasy.props.api.PropertyInjectionException;
import org.jeasy.props.converters.TypeConverter;
import org.jeasy.props.processors.DBPropertyAnnotationProcessor;
import org.jeasy.props.processors.EnvironmentVariableAnnotationProcessor;
import org.jeasy.props.processors.I18NPropertyAnnotationProcessor;
import org.jeasy.props.processors.JNDIPropertyAnnotationProcessor;
import org.jeasy.props.processors.ManifestPropertyAnnotationProcessor;
import org.jeasy.props.processors.MavenPropertyAnnotationProcessor;
import org.jeasy.props.processors.PropertiesAnnotationProcessor;
import org.jeasy.props.processors.PropertyAnnotationProcessor;
import org.jeasy.props.processors.SystemPropertyAnnotationProcessor;

class PropertyInjector {
    private static final Logger LOGGER = Logger.getLogger(PropertyInjector.class.getName());
    private static final String WARNING = "Unable to inject value from annotation '%s' on field '%s' of type '%s' in class '%s'";
    private static final List<Class<? extends Annotation>> builtinAnnotations = Arrays.asList(SystemProperty.class, Property.class, I18NProperty.class, Properties.class, DBProperty.class, JNDIProperty.class, MavenProperty.class, ManifestProperty.class, EnvironmentVariable.class);
    private final Map<Class<? extends Annotation>, AnnotationProcessor> annotationProcessors = new HashMap<Class<? extends Annotation>, AnnotationProcessor>();
    private final Map<Class<?>, TypeConverter<?, ?>> typeConverters = new HashMap();

    PropertyInjector() {
        this.annotationProcessors.put(SystemProperty.class, new SystemPropertyAnnotationProcessor());
        this.annotationProcessors.put(Property.class, new PropertyAnnotationProcessor());
        this.annotationProcessors.put(I18NProperty.class, new I18NPropertyAnnotationProcessor());
        this.annotationProcessors.put(Properties.class, new PropertiesAnnotationProcessor());
        this.annotationProcessors.put(DBProperty.class, new DBPropertyAnnotationProcessor());
        this.annotationProcessors.put(JNDIProperty.class, new JNDIPropertyAnnotationProcessor());
        this.annotationProcessors.put(MavenProperty.class, new MavenPropertyAnnotationProcessor());
        this.annotationProcessors.put(ManifestProperty.class, new ManifestPropertyAnnotationProcessor());
        this.annotationProcessors.put(EnvironmentVariable.class, new EnvironmentVariableAnnotationProcessor());
    }

    void injectProperty(Field field, Object object) throws PropertyInjectionException {
        List<? extends Annotation> sortedAnnotations = this.sortAnnotationsByOrder(field);
        for (Annotation annotation : sortedAnnotations) {
            AnnotationProcessor annotationProcessor;
            Object value = this.getValue(field, object, annotation, annotationProcessor = this.annotationProcessors.get(annotation.annotationType()));
            if (value != null) {
                this.doInjectProperty(value, field, object);
                break;
            }
            LOGGER.log(Level.FINE, String.format(WARNING, annotation, field.getName(), field.getType().getName(), object.getClass().getName()));
        }
    }

    private List<? extends Annotation> sortAnnotationsByOrder(Field field) {
        class AnnotationWithOrder
        implements Comparable<AnnotationWithOrder> {
            final Annotation annotation;
            final int order;

            AnnotationWithOrder(Annotation annotation, int order) {
                this.annotation = annotation;
                this.order = order;
            }

            @Override
            public int compareTo(AnnotationWithOrder o) {
                return Integer.compare(this.order, o.order);
            }
        }
        return Arrays.stream(field.getDeclaredAnnotations()).filter(annotation -> !builtinAnnotations.contains(annotation.getClass())).map(annotation -> new AnnotationWithOrder((Annotation)annotation, this.getOrder((Annotation)annotation))).sorted().map(annotationWithOrder -> annotationWithOrder.annotation).collect(Collectors.toList());
    }

    private int getOrder(Annotation annotation) {
        if (annotation instanceof Property) {
            return ((Property)annotation).order();
        }
        if (annotation instanceof Properties) {
            return ((Properties)annotation).order();
        }
        if (annotation instanceof SystemProperty) {
            return ((SystemProperty)annotation).order();
        }
        if (annotation instanceof EnvironmentVariable) {
            return ((EnvironmentVariable)annotation).order();
        }
        if (annotation instanceof MavenProperty) {
            return ((MavenProperty)annotation).order();
        }
        if (annotation instanceof I18NProperty) {
            return ((I18NProperty)annotation).order();
        }
        if (annotation instanceof ManifestProperty) {
            return ((ManifestProperty)annotation).order();
        }
        if (annotation instanceof DBProperty) {
            return ((DBProperty)annotation).order();
        }
        if (annotation instanceof JNDIProperty) {
            return ((JNDIProperty)annotation).order();
        }
        return 0;
    }

    private <A extends Annotation> Object getValue(Field field, Object object, A annotation, AnnotationProcessor<A> annotationProcessor) throws PropertyInjectionException {
        try {
            return annotationProcessor.processAnnotation(annotation, field);
        }
        catch (Exception e) {
            throw new PropertyInjectionException(String.format(WARNING, annotation, field.getName(), field.getType().getName(), object.getClass().getName()), e);
        }
    }

    private void doInjectProperty(Object value, Field field, Object object) throws PropertyInjectionException {
        try {
            Object typedValue = this.convert(value, field.getType());
            this.setProperty(typedValue, field, object);
        }
        catch (Exception e) {
            throw new PropertyInjectionException(String.format(WARNING, value, field.getName(), field.getType().getName(), object.getClass().getName()), e);
        }
    }

    private Object convert(Object value, Class<?> type) {
        TypeConverter<?, ?> converter = this.typeConverters.get(type);
        if (converter != null) {
            return converter.convert(value);
        }
        return ConvertUtils.convert((Object)value, type);
    }

    private void setProperty(Object value, Field field, Object targetObject) throws Exception {
        boolean access = field.isAccessible();
        field.setAccessible(true);
        field.set(targetObject, value);
        field.setAccessible(access);
    }

    void addAnnotationProcessor(Class<? extends Annotation> annotation, AnnotationProcessor annotationProcessor) {
        this.annotationProcessors.put(annotation, annotationProcessor);
    }

    void addTypeConverter(Class<?> type, TypeConverter typeConverter) {
        this.typeConverters.put(type, typeConverter);
    }
}

