/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.props.annotations.EnvironmentVariable;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;

public class EnvironmentVariableAnnotationProcessor
extends AbstractAnnotationProcessor<EnvironmentVariable> {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentVariableAnnotationProcessor.class.getName());

    @Override
    public Object processAnnotation(EnvironmentVariable environmentVariable, Field field) throws AnnotationProcessingException {
        String key = environmentVariable.value().trim();
        String defaultValue = environmentVariable.defaultValue();
        boolean failFast = environmentVariable.failFast();
        this.rejectIfEmpty(key, this.missingAttributeValue("value", EnvironmentVariable.class.getName(), field));
        String value = System.getenv(key);
        if (value == null) {
            String message = String.format("Environment variable '%s' on field '%s' of type '%s' in class '%s' not found in environment variables", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
            LOGGER.log(Level.WARNING, message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue.trim();
            } else {
                LOGGER.log(Level.WARNING, "Default value of environment variable ''{0}'' on field ''{1}'' of type ''{2}'' in class ''{3}'' is empty", new Object[]{key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName()});
                return null;
            }
        }
        return value;
    }
}

