/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.props.annotations.MavenProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;

public class MavenPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<MavenProperty> {
    private static final Logger LOGGER = Logger.getLogger(MavenPropertyAnnotationProcessor.class.getName());
    private final Map<String, Properties> mavenMap = new HashMap<String, Properties>();

    @Override
    public Object processAnnotation(MavenProperty mavenAnnotation, Field field) throws AnnotationProcessingException {
        String value;
        String key = mavenAnnotation.key().trim();
        String source = mavenAnnotation.source().trim();
        String groupId = mavenAnnotation.groupId().trim();
        String artifactId = mavenAnnotation.artifactId().trim();
        String defaultValue = mavenAnnotation.defaultValue().trim();
        boolean failFast = mavenAnnotation.failFast();
        String annotationName = MavenProperty.class.getName();
        this.rejectIfEmpty(key, this.missingAttributeValue("key", annotationName, field));
        this.rejectIfEmpty(groupId, this.missingAttributeValue("groupId", annotationName, field));
        this.rejectIfEmpty(artifactId, this.missingAttributeValue("artifactId", annotationName, field));
        String pomFile = "META-INF/maven/" + groupId + "/" + artifactId + "/" + source;
        if (!this.mavenMap.containsKey(pomFile)) {
            this.loadMavenProperties(pomFile);
        }
        if ((value = this.mavenMap.get(pomFile).getProperty(key)) == null) {
            String message = String.format("Maven property '%s' on field '%s' of type '%s' in class '%s' not found in pom file '%s'", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName(), pomFile);
            LOGGER.log(Level.WARNING, message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue;
            } else {
                return null;
            }
        }
        if (value.isEmpty()) {
            LOGGER.log(Level.WARNING, "Maven property ''{0}'' is empty in pom file ''{1}''", new Object[]{key, pomFile});
            return null;
        }
        return value;
    }

    private void loadMavenProperties(String pomFile) throws AnnotationProcessingException {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getResourceAsStream(pomFile);
            if (inputStream == null) {
                throw new AnnotationProcessingException(String.format("Unable to load pom file from '%s'", pomFile));
            }
            properties.load(inputStream);
            this.mavenMap.put(pomFile, properties);
        }
        catch (IOException e) {
            throw new AnnotationProcessingException(String.format("Unable to load pom file from '%s'", pomFile), e);
        }
    }
}

