/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.props.annotations.Property;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;

public class PropertyAnnotationProcessor
extends AbstractAnnotationProcessor<Property> {
    private static final Logger LOGGER = Logger.getLogger(PropertyAnnotationProcessor.class.getName());
    private final Map<String, Properties> propertiesMap = new HashMap<String, Properties>();

    @Override
    public Object processAnnotation(Property property, Field field) throws AnnotationProcessingException {
        String value;
        String source = property.source().trim();
        String key = property.key().trim();
        String defaultValue = property.defaultValue().trim();
        boolean failFast = property.failFast();
        String annotationName = Property.class.getName();
        this.rejectIfEmpty(source, this.missingAttributeValue("source", annotationName, field));
        this.rejectIfEmpty(key, this.missingAttributeValue("key", annotationName, field));
        if (!this.propertiesMap.containsKey(source)) {
            this.loadProperties(source);
        }
        if ((value = this.propertiesMap.get(source).getProperty(key)) == null) {
            String message = String.format("Property '%s' on field '%s' of type '%s' in class '%s' not found in properties file '%s'", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName(), source);
            LOGGER.log(Level.WARNING, message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue;
            } else {
                return null;
            }
        }
        if (value.isEmpty()) {
            LOGGER.log(Level.WARNING, "Property ''{0}'' is empty in properties file ''{1}''", new Object[]{key, source});
            return null;
        }
        return value;
    }

    private void loadProperties(String source) throws AnnotationProcessingException {
        block6: {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = this.getResourceAsStream(source);
                if (inputStream != null) {
                    properties.load(inputStream);
                    this.propertiesMap.put(source, properties);
                    break block6;
                }
                throw new AnnotationProcessingException(String.format("Unable to load properties from source '%s'", source));
            }
            catch (IOException e) {
                throw new AnnotationProcessingException(String.format("Unable to load properties from source '%s'", source), e);
            }
            finally {
                this.closeInputStream(inputStream);
            }
        }
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to close input stream", e);
            }
        }
    }
}

