/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jeasy.props.annotations.SystemProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;

public class SystemPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<SystemProperty> {
    private static final Logger LOGGER = Logger.getLogger(SystemPropertyAnnotationProcessor.class.getName());

    @Override
    public Object processAnnotation(SystemProperty systemProperty, Field field) throws AnnotationProcessingException {
        String key = systemProperty.value().trim();
        String defaultValue = systemProperty.defaultValue();
        boolean failFast = systemProperty.failFast();
        this.rejectIfEmpty(key, this.missingAttributeValue("value", SystemProperty.class.getName(), field));
        String value = System.getProperty(key);
        if (value == null) {
            String message = String.format("System property '%s' on field '%s' of type '%s' in class '%s' not found in system properties", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
            LOGGER.log(Level.WARNING, message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue.trim();
            } else {
                LOGGER.log(Level.WARNING, "Default value of system property ''{0}'' on field ''{1}'' of type ''{2}'' in class ''{3}'' is empty", new Object[]{key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName()});
                return null;
            }
        }
        return value;
    }
}

