/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import org.jeasy.props.api.PropertiesInjector;
import org.jeasy.props.api.PropertyInjectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertiesInjectionTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesInjectionTask.class);
    private final PropertiesInjector injector;
    private final Object target;

    PropertiesInjectionTask(PropertiesInjector injector, Object target) {
        this.injector = injector;
        this.target = target;
    }

    @Override
    public void run() {
        try {
            this.injector.injectProperties(this.target);
        }
        catch (PropertyInjectionException e) {
            LOGGER.error("Unable to inject properties in object '" + this.target + "'", (Throwable)e);
        }
    }
}

