/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static List<Field> getAllFields(Object object) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(ReflectionUtils.getDeclaredFields(object));
        allFields.addAll(ReflectionUtils.getInheritedFields(object));
        return allFields;
    }

    private static List<Field> getDeclaredFields(Object object) {
        return Arrays.asList(object.getClass().getDeclaredFields());
    }

    private static List<Field> getInheritedFields(Object object) {
        ArrayList<Field> inheritedFields = new ArrayList<Field>();
        Class<?> clazz = object.getClass();
        while (clazz.getSuperclass() != null) {
            Class<?> superclass = clazz.getSuperclass();
            inheritedFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
            clazz = superclass;
        }
        return inheritedFields;
    }
}

