/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import org.jeasy.props.annotations.EnvironmentVariable;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentVariableAnnotationProcessor
extends AbstractAnnotationProcessor<EnvironmentVariable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentVariableAnnotationProcessor.class);

    @Override
    public Object processAnnotation(EnvironmentVariable environmentVariable, Field field) throws AnnotationProcessingException {
        String key = environmentVariable.value().trim();
        String defaultValue = environmentVariable.defaultValue();
        boolean failFast = environmentVariable.failFast();
        this.rejectIfEmpty(key, this.missingAttributeValue("value", EnvironmentVariable.class.getName(), field));
        String value = System.getenv(key);
        if (value == null) {
            String message = String.format("Environment variable '%s' on field '%s' of type '%s' in class '%s' not found in environment variables", key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName());
            LOGGER.warn(message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue.trim();
            } else {
                LOGGER.warn("Default value of environment variable '{}' on field '{}' of type '{}' in class '{}' is empty", new Object[]{key, field.getName(), field.getType().getName(), field.getDeclaringClass().getName()});
                return null;
            }
        }
        return value;
    }
}

