/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jeasy.props.annotations.I18NProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<I18NProperty> {
    private static final Logger LOGGER = LoggerFactory.getLogger(I18NPropertyAnnotationProcessor.class);
    private final Map<String, ResourceBundle> resourceBundlesMap = new HashMap<String, ResourceBundle>();

    @Override
    public Object processAnnotation(I18NProperty property, Field field) throws AnnotationProcessingException {
        String value;
        block5: {
            String key = property.key().trim();
            String bundle = property.bundle().trim();
            String language = property.language().trim();
            String country = property.country().trim();
            String variant = property.variant().trim();
            String defaultValue = property.defaultValue().trim();
            boolean failFast = property.failFast();
            String annotationName = I18NProperty.class.getName();
            this.rejectIfEmpty(bundle, this.missingAttributeValue("bundle", annotationName, field));
            this.rejectIfEmpty(key, this.missingAttributeValue("key", annotationName, field));
            Locale locale = this.getLocale(language, country, variant);
            if (!this.resourceBundlesMap.containsKey(bundle)) {
                this.loadResourceBundle(bundle, locale);
            }
            value = null;
            try {
                value = this.resourceBundlesMap.get(bundle).getString(key);
                if (value.isEmpty()) {
                    LOGGER.warn("Key '{}' is empty in resource bundle '{}'", (Object)key, (Object)bundle);
                    return null;
                }
            }
            catch (MissingResourceException e) {
                String message = String.format("Key '%s' not found in resource bundle '%s'", key, bundle);
                LOGGER.warn(message, (Throwable)e);
                if (failFast) {
                    throw new AnnotationProcessingException(message);
                }
                if (defaultValue.isEmpty()) break block5;
                value = defaultValue;
            }
        }
        return value;
    }

    private Locale getLocale(String language, String country, String variant) {
        Locale locale = Locale.getDefault();
        if (!language.isEmpty()) {
            locale = new Locale(language);
        }
        if (!language.isEmpty() && !country.isEmpty()) {
            locale = new Locale(language, country);
        }
        if (!(language.isEmpty() || country.isEmpty() || variant.isEmpty())) {
            locale = new Locale(language, country, variant);
        }
        return locale;
    }

    private void loadResourceBundle(String bundle, Locale locale) throws AnnotationProcessingException {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundle, locale);
            this.resourceBundlesMap.put(bundle, resourceBundle);
        }
        catch (MissingResourceException e) {
            throw new AnnotationProcessingException(String.format("Resource bundle '%s' not found", bundle), e);
        }
    }
}

