/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.props.processors;

import java.lang.reflect.Field;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jeasy.props.annotations.JNDIProperty;
import org.jeasy.props.api.AnnotationProcessingException;
import org.jeasy.props.processors.AbstractAnnotationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNDIPropertyAnnotationProcessor
extends AbstractAnnotationProcessor<JNDIProperty> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JNDIPropertyAnnotationProcessor.class);
    private Context context;

    @Override
    public Object processAnnotation(JNDIProperty jndiPropertyAnnotation, Field field) throws AnnotationProcessingException {
        if (this.context == null) {
            try {
                this.context = new InitialContext();
            }
            catch (NamingException e) {
                throw new AnnotationProcessingException("Unable to initialize JNDI context", e);
            }
        }
        String name = jndiPropertyAnnotation.value().trim();
        String defaultValue = jndiPropertyAnnotation.defaultValue().trim();
        boolean failFast = jndiPropertyAnnotation.failFast();
        this.rejectIfEmpty(name, this.missingAttributeValue("name", JNDIProperty.class.getName(), field));
        Object value = this.getObjectFromJndiContext(name);
        if (value == null) {
            String message = String.format("Object '%s' not found in JNDI context", name);
            LOGGER.warn(message);
            if (failFast) {
                throw new AnnotationProcessingException(message);
            }
            if (!defaultValue.isEmpty()) {
                value = defaultValue;
            }
        }
        return value;
    }

    private Object getObjectFromJndiContext(String name) throws AnnotationProcessingException {
        try {
            Object value = this.context.lookup(name);
            return value;
        }
        catch (NamingException e) {
            throw new AnnotationProcessingException(String.format("Unable to lookup object '%s' from JNDI context", name), e);
        }
    }
}

