/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.states.core;

import java.util.Set;
import org.jeasy.states.api.FiniteStateMachine;
import org.jeasy.states.api.State;
import org.jeasy.states.api.Transition;
import org.jeasy.states.core.FiniteStateMachineDefinitionValidator;
import org.jeasy.states.core.FiniteStateMachineImpl;
import org.jeasy.states.core.TransitionDefinitionValidator;

public class FiniteStateMachineBuilder {
    private FiniteStateMachineImpl finiteStateMachine;
    private FiniteStateMachineDefinitionValidator finiteStateMachineDefinitionValidator;
    private TransitionDefinitionValidator transitionDefinitionValidator;

    public FiniteStateMachineBuilder(Set<State> states, State initialState) {
        this.finiteStateMachine = new FiniteStateMachineImpl(states, initialState);
        this.finiteStateMachineDefinitionValidator = new FiniteStateMachineDefinitionValidator();
        this.transitionDefinitionValidator = new TransitionDefinitionValidator();
    }

    public FiniteStateMachineBuilder registerTransition(Transition transition) {
        this.transitionDefinitionValidator.validateTransitionDefinition(transition, this.finiteStateMachine);
        this.finiteStateMachine.registerTransition(transition);
        return this;
    }

    public FiniteStateMachineBuilder registerTransitions(Set<Transition> transitions) {
        for (Transition transition : transitions) {
            this.registerTransition(transition);
        }
        return this;
    }

    public FiniteStateMachineBuilder registerFinalState(State finalState) {
        this.finiteStateMachine.registerFinalState(finalState);
        return this;
    }

    public FiniteStateMachineBuilder registerFinalStates(Set<State> finalStates) {
        for (State finalState : finalStates) {
            this.registerFinalState(finalState);
        }
        return this;
    }

    public FiniteStateMachine build() {
        this.finiteStateMachineDefinitionValidator.validateFiniteStateMachineDefinition(this.finiteStateMachine);
        return this.finiteStateMachine;
    }
}

